/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblemDataSource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IRoadmapSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.solver.IRoadmapPlanningProblemSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.solver.RoadmapSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.solver.SolverConfiguration;
import com.atlassian.rm.jpo.scheduling.util.graph.CyclesDetectedException;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolution;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestSchedulingSolutionFactory;
import com.radiantminds.roadmap.common.scheduling.CalculationProcess;
import com.radiantminds.roadmap.common.scheduling.CalculationResult;
import com.radiantminds.roadmap.common.scheduling.CalculationStateVitalityWrapper;
import com.radiantminds.roadmap.common.scheduling.CalculationVitalityHandler;
import com.radiantminds.roadmap.common.scheduling.PlanSolverConfiguration;
import com.radiantminds.roadmap.common.scheduling.Threading;
import com.radiantminds.roadmap.common.scheduling.common.TimeTransformer;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IPlanSolution;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.RoadmapToPlanSolutionTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.NoEstimatedWorkItemsDefinedException;
import com.radiantminds.roadmap.common.scheduling.trafo.RoadmapProblemTransformer;

public class LocalCalculationProcess
implements CalculationProcess {
    private static final Log LOGGER = Log.with(LocalCalculationProcess.class);
    private final SchedulingPlan schedulingPlan;
    private final String calculationId;
    private final int planningHorizonInDays;
    private final CalculationVitalityHandler vitalityHandler;

    public LocalCalculationProcess(SchedulingPlan schedulingPlan, String calculationId, int planningHorizonInDays, CalculationVitalityHandler vitalityHandler) {
        this.schedulingPlan = schedulingPlan;
        this.calculationId = calculationId;
        this.planningHorizonInDays = planningHorizonInDays;
        this.vitalityHandler = vitalityHandler;
    }

    @Override
    public CalculationResult execute() throws InterruptedException, NoEstimatedWorkItemsDefinedException, CyclesDetectedException {
        long t1 = System.currentTimeMillis();
        TimeTransformer timeTransformerForSolution = TimeTransformer.createFromPlan(this.schedulingPlan);
        Threading.testInterrupted();
        RoadmapProblemTransformer roadmapTransformer = RoadmapProblemTransformer.createInstance(timeTransformerForSolution, this.schedulingPlan, this.planningHorizonInDays);
        Threading.testInterrupted();
        IRoadmapProblemDataSource problemDataSource = roadmapTransformer.createProblemDataSource(this.schedulingPlan);
        Threading.testInterrupted();
        SolverConfiguration solverConfiguration = PlanSolverConfiguration.createForPlan(this.schedulingPlan);
        IRoadmapPlanningProblemSolver solver = RoadmapSolver.createInstance(solverConfiguration, new CalculationStateVitalityWrapper(this.vitalityHandler, this.calculationId));
        Threading.testInterrupted();
        long solverCreationTime = System.currentTimeMillis() - t1;
        LOGGER.info("[process]\tCreate solver:\t" + solverCreationTime + "ms", new Object[0]);
        long t2 = System.currentTimeMillis();
        IRoadmapSchedule result = solver.solveRoadmapPlanningProblem(problemDataSource);
        RoadmapToPlanSolutionTransformer transformer = new RoadmapToPlanSolutionTransformer(timeTransformerForSolution);
        IPlanSolution convertedSolution = transformer.transform(this.schedulingPlan.getSchedulingVersion(), result, problemDataSource.getRoadmapProblem());
        Threading.testInterrupted();
        RestSchedulingSolution solution = RestSchedulingSolutionFactory.create(this.schedulingPlan, convertedSolution, problemDataSource.getRoadmapProblem());
        long solveTime = System.currentTimeMillis() - t2;
        LOGGER.info("[process]\tCreate solve:\t" + solveTime + "ms", new Object[0]);
        solution.setMetaData(solverCreationTime, solveTime);
        CalculationResult.Impl retVal = new CalculationResult.Impl(this.calculationId, solution, solverCreationTime, solveTime);
        return retVal;
    }
}

