/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams.point;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.ResourceGroupFactory;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.WorkSlotsDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkSlotFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.Resource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.ImmutableNonEmptyPositivePrimitivesMap;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingPerson;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.ScrumSprintTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.common.SupplyFactorMapCreator;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.point.AdjustedResourceRatioSupplyFunctionCreator;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.point.BasePointTeamTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.point.ResourceRatioSupplyFunctionCreator;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
public class PointsTeamCreator
extends BasePointTeamTransformer {
    private static final Log LOGGER = Log.with(PointsTeamCreator.class);
    private final SupplyFactorMapCreator supplyFactorMapCreator;
    private final AdjustedResourceRatioSupplyFunctionCreator availabilityRatioSupplyFunctionCreator;
    private final ResourceRatioSupplyFunctionCreator teamQuotaSupplyFunctionCreator;

    public PointsTeamCreator(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this(new AdjustedResourceRatioSupplyFunctionCreator(timeTransformer, timeStepPresenceFunction), new ResourceRatioSupplyFunctionCreator(timeTransformer, timeStepPresenceFunction), new SupplyFactorMapCreator(), new ScrumSprintTransformer(timeTransformer, timeStepPresenceFunction));
    }

    PointsTeamCreator(AdjustedResourceRatioSupplyFunctionCreator availabilityRatioSupplyFunctionCreator, ResourceRatioSupplyFunctionCreator teamQuotaSupplyFunctionCreator, SupplyFactorMapCreator supplyFactorMapCreator, ScrumSprintTransformer sprintTransformer) {
        super(sprintTransformer);
        this.availabilityRatioSupplyFunctionCreator = availabilityRatioSupplyFunctionCreator;
        this.teamQuotaSupplyFunctionCreator = teamQuotaSupplyFunctionCreator;
        this.supplyFactorMapCreator = supplyFactorMapCreator;
    }

    public Optional<IResourceGroup> createWorkResources(SchedulingTeam team, IResourceTypeMapping resourceTypeMapping, SchedulingPlan plan) {
        WorkSlotsDefinition slotDefinition = this.sprintTransformer.createWorkSlotDefinition(team, plan.getPlanConfiguration().getGlobalSprintLength());
        float velocity = this.getVelocity(team, plan.getPlanConfiguration().getGlobalDefaultVelocity());
        Map<SchedulingResource, IWorkSlotFunction> resourceAvailabilities = this.getResourceAvailabilities(team, plan, slotDefinition, velocity);
        HashSet transformedResources = Sets.newHashSet();
        for (Map.Entry<SchedulingResource, IWorkSlotFunction> entry : resourceAvailabilities.entrySet()) {
            Optional<IWorkResource> transformed = this.tryCreateWorkResource(entry.getKey(), (SchedulingPerson)plan.getPerson(entry.getKey().getPersonId()).get(), resourceTypeMapping, team, entry.getValue());
            if (!transformed.isPresent()) continue;
            transformedResources.add(transformed.get());
        }
        if (transformedResources.isEmpty()) {
            LOGGER.debug("team has no transformed resources - ignored", new Object[0]);
            return Optional.absent();
        }
        ResourceGroup group = ResourceGroupFactory.createResourceGroup(team.getId(), transformedResources, slotDefinition, null, team.getSortOrder().toString(), (Boolean)Optional.fromNullable((Object)plan.getPlanConfiguration().getStrictStageDivision()).or((Object)true));
        LOGGER.debug("created resource group: %s", group);
        return Optional.of((Object)group);
    }

    private Map<SchedulingResource, IWorkSlotFunction> getResourceAvailabilities(SchedulingTeam team, SchedulingPlan plan, WorkSlotsDefinition slotsDefinition, float velocity) {
        Boolean autoAdjustToAbsences = team.getAutoAdjustToAbsences();
        if (autoAdjustToAbsences != null && autoAdjustToAbsences.booleanValue()) {
            return this.availabilityRatioSupplyFunctionCreator.getResourceSupplyFunctions(team, plan, slotsDefinition, velocity);
        }
        return this.teamQuotaSupplyFunctionCreator.getResourceSupplyFunctions(team, plan, slotsDefinition, velocity);
    }

    private Optional<IWorkResource> tryCreateWorkResource(SchedulingResource resource, SchedulingPerson person, IResourceTypeMapping resourceTypeMapping, SchedulingTeam team, IWorkSlotFunction supplyFunction) {
        LOGGER.debug("create multi resource for resource: %s", resource);
        String id = resource.getId();
        Optional<ImmutableNonEmptyPositivePrimitivesMap<IResourceType>> resourceSupplyMap = this.supplyFactorMapCreator.createSupplyMap(person, resourceTypeMapping);
        if (!resourceSupplyMap.isPresent()) {
            LOGGER.debug("resource has no needed skills - ignored", new Object[0]);
            return Optional.absent();
        }
        String sortKey = team.getSortOrder().toString() + "-" + resource.getSortOrder().toString();
        Resource workResource = new Resource(id, team.getId(), (ImmutableNonEmptyPositivePrimitivesMap)resourceSupplyMap.get(), supplyFunction, null, sortKey);
        LOGGER.debug("created multi resource: %s", workResource);
        return Optional.of((Object)workResource);
    }
}

