/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.extension.issues.sync.jpo2jira;

import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.google.common.base.Objects;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.jira.common.components.extension.issues.sync.FormattingUtils;
import com.radiantminds.roadmap.jira.common.components.issues.sync.SyncTask;
import java.util.Locale;
import java.util.Set;

class StoryPointsSyncTask
implements SyncTask {
    private final Double storyPoints;
    private final Locale locale;
    private final CustomField storyPointsCustomField;
    private final Set<String> storyPointIssueTypes;

    public StoryPointsSyncTask(Double storyPoints, Locale locale, CustomField storyPointsCustomField, Set<String> storyPointIssueTypes) {
        this.storyPoints = storyPoints;
        this.locale = locale;
        this.storyPointsCustomField = storyPointsCustomField;
        this.storyPointIssueTypes = storyPointIssueTypes;
    }

    @Override
    public boolean apply(MutableIssue issue, IssueInputParameters issueInputParameters) {
        if (this.storyPointsCustomField.isGlobal() || this.storyPointIssueTypes.contains(issue.getIssueTypeObject().getId())) {
            String formattedStoryPoints;
            String string = formattedStoryPoints = this.storyPoints == 0.0 ? "" : FormattingUtils.formatStoryPoints(this.locale, this.storyPoints);
            if (Objects.equal((Object)issue.getCustomFieldValue(this.storyPointsCustomField), (Object)formattedStoryPoints)) {
                return false;
            }
            issueInputParameters.addCustomFieldValue(this.storyPointsCustomField.getIdAsLong(), new String[]{formattedStoryPoints});
            return true;
        }
        return false;
    }

    @Override
    public boolean apply(IWorkItem workItem) {
        throw new UnsupportedOperationException();
    }
}

