/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.jira.common.components.issues;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.jira.common.components.issues.IssueFieldChange;
import com.radiantminds.roadmap.jira.common.components.issues.SyncableFields;
import java.util.Map;

public class IssueFieldChanges {
    private final Map<String, IssueFieldChange> changeMap;
    private final SyncableFields syncableFields;

    public IssueFieldChanges(SyncableFields syncableFields) {
        this.syncableFields = syncableFields;
        this.changeMap = Maps.newHashMap();
    }

    public void add(IssueFieldChange change) {
        this.changeMap.put(change.getField(), change);
    }

    boolean hasRelevantChanges() {
        for (String key : this.syncableFields.getSyncableFieldKeys()) {
            if (!this.changeMap.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public Optional<IssueFieldChange> forField(String fieldName) {
        return Optional.fromNullable((Object)this.changeMap.get(fieldName));
    }

    public Optional<IssueFieldChange> forDescription() {
        return this.forField("description");
    }

    public Optional<IssueFieldChange> forSummary() {
        Optional<IssueFieldChange> epicTitleFieldChange;
        Optional<String> epicLabelFieldKey = this.syncableFields.getEpicLabelFieldKey();
        if (epicLabelFieldKey.isPresent() && (epicTitleFieldChange = this.forField((String)epicLabelFieldKey.get())).isPresent()) {
            return epicTitleFieldChange;
        }
        return this.forField("summary");
    }

    public Optional<IssueFieldChange> forOriginalEstimates() {
        return this.forField("timeoriginalestimate");
    }

    public Optional<IssueFieldChange> forStoryPoints() {
        Optional<String> storyPointsFieldKey = this.syncableFields.getStoryPointsFieldKey();
        if (storyPointsFieldKey.isPresent()) {
            return this.forField((String)storyPointsFieldKey.get());
        }
        return Optional.absent();
    }
}

