/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.persistence;

import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.api.persistence.PersistenceService;
import com.opensymphony.module.propertyset.PropertyException;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersistenceServiceImpl
implements PersistenceService {
    private final Logger log = Logger.getLogger(this.getClass());
    private JiraPropertySetFactory propertySetFactory;

    @Autowired
    public PersistenceServiceImpl(JiraPropertySetFactory propertySetFactory) {
        this.propertySetFactory = propertySetFactory;
    }

    private static void assertPreconditions(String entityName, Long entityId, String key) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Validate.notNull((Object)key);
    }

    @Override
    public void setLong(String entityName, Long entityId, String key, Long value) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        Validate.notNull((Object)value);
        this.getPropertySet(entityName, entityId).setLong(key, value.longValue());
    }

    @Override
    public Long getLong(String entityName, Long entityId, String key) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        return this.exists(entityName, entityId, key) ? Long.valueOf(this.getPropertySet(entityName, entityId).getLong(key)) : null;
    }

    @Override
    public void setText(String entityName, Long entityId, String key, String value) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        Validate.notNull((Object)value);
        this.getPropertySet(entityName, entityId).setText(key, value);
    }

    @Override
    public String getText(String entityName, Long entityId, String key) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        return this.exists(entityName, entityId, key) ? this.getPropertySet(entityName, entityId).getText(key) : null;
    }

    @Override
    public void setDouble(String entityName, Long entityId, String key, Double value) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        Validate.notNull((Object)value);
        this.getPropertySet(entityName, entityId).setDouble(key, value.doubleValue());
    }

    @Override
    public Double getDouble(String entityName, Long entityId, String key) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        return this.exists(entityName, entityId, key) ? Double.valueOf(this.getPropertySet(entityName, entityId).getDouble(key)) : null;
    }

    @Override
    public void setBoolean(String entityName, Long entityId, String key, Boolean value) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        Validate.notNull((Object)value);
        this.getPropertySet(entityName, entityId).setBoolean(key, value.booleanValue());
    }

    @Override
    public Boolean getBoolean(String entityName, Long entityId, String key) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        return this.exists(entityName, entityId, key) ? Boolean.valueOf(this.getPropertySet(entityName, entityId).getBoolean(key)) : null;
    }

    @Override
    public Map<String, Object> getData(String entityName, Long entityId, String key) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        String serializedData = this.getPropertySet(entityName, entityId).getText(key);
        if (serializedData == null) {
            return null;
        }
        return this.toMap(serializedData);
    }

    @Override
    public void setData(String entityName, Long entityId, String key, Map<String, Object> data) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        Validate.notNull(data);
        JSONObject jsonObject = new JSONObject(data);
        String serializedData = jsonObject.toString();
        this.getPropertySet(entityName, entityId).setText(key, serializedData);
    }

    @Override
    public List<Object> getListData(String entityName, Long entityId, String key) {
        Validate.notNull((Object)entityName, (String)"entityName must not be null");
        Validate.notNull((Object)entityId, (String)"entityId must not be null");
        Validate.notNull((Object)key, (String)"key must not be null");
        String serializedData = this.getPropertySet(entityName, entityId).getText(key);
        if (serializedData == null) {
            return null;
        }
        return this.toList(serializedData);
    }

    @Override
    public void setListData(String entityName, Long entityId, String key, List<Object> data) {
        Validate.notNull((Object)entityName, (String)"entityName must not be null");
        Validate.notNull((Object)entityId, (String)"entityId must not be null");
        Validate.notNull((Object)key, (String)"key must not be null");
        Validate.notNull(data, (String)"data must not be null");
        String serializedData = new JSONArray(data).toString();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Storing list data in property set: " + entityName + ":" + entityId + " => " + key + ":" + serializedData));
        }
        this.getPropertySet(entityName, entityId).setText(key, serializedData);
    }

    private Map<String, Object> toMap(String serializedData) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            JSONObject jsonObject = new JSONObject(serializedData);
            Iterator it = jsonObject.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                map.put(key, jsonObject.get(key));
            }
            return map;
        }
        catch (JSONException e) {
            throw new RuntimeException("Code Assertion : How did we store JSON and not be able to parse it?", e);
        }
    }

    private List<Object> toList(String serializedData) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            JSONArray array = new JSONArray(serializedData);
            for (int i = 0; i < array.length(); ++i) {
                list.add(array.get(i));
            }
            return list;
        }
        catch (JSONException e) {
            throw new RuntimeException("Code Assertion : How did we store JSON and not be able to parse it?", e);
        }
    }

    @Override
    public Set<String> getKeys(String entityName, Long entityId) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        Collection keys = this.getPropertySet(entityName, entityId).getKeys();
        if (keys.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> keySet = new HashSet<String>();
        for (Object key : keys) {
            keySet.add((String)key);
        }
        return keySet;
    }

    @Override
    public boolean exists(String entityName, Long entityId, String key) {
        return this.getPropertySet(entityName, entityId).exists(key);
    }

    @Override
    public void delete(String entityName, Long entityId, String key) {
        PersistenceServiceImpl.assertPreconditions(entityName, entityId, key);
        PropertySet propertySet = this.getPropertySet(entityName, entityId);
        this.removeProperty(propertySet, key);
    }

    @Override
    public void deleteAll(String entityName, Long entityId) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        PropertySet propertySet = this.getPropertySet(entityName, entityId);
        Collection keys = propertySet.getKeys();
        for (Object key : keys) {
            this.removeProperty(propertySet, (String)key);
        }
    }

    private PropertySet getPropertySet(String entityName, Long entityId) {
        Validate.notNull((Object)entityName);
        Validate.notNull((Object)entityId);
        return this.propertySetFactory.buildCachingPropertySet(entityName, entityId, false);
    }

    private void removeProperty(PropertySet propertySet, String key) {
        try {
            if (propertySet.exists(key)) {
                propertySet.remove(key);
            }
        }
        catch (PropertyException e) {
            this.log.warn((Object)e, (Throwable)e);
        }
    }
}

