/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene.collectors;

import com.atlassian.rm.common.bridges.lucene.collectors.AllDocsCollector73;
import com.atlassian.rm.common.bridges.lucene.collectors.FirstPassGroupingResult;
import com.atlassian.rm.common.bridges.lucene.collectors.GroupResult;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.BytesRef;

public class AllDocsSecondPassGroupCollector73
extends SimpleCollector {
    private final String groupField;
    private final List<GroupResult> groupResults;
    private final Map<String, GroupValueCollector> collectors;
    private Map<Integer, GroupValueCollector> orderedCollectors;
    private LeafReader leafReader;
    private SortedDocValues docValues;

    public AllDocsSecondPassGroupCollector73(String groupField, FirstPassGroupingResult firstPassResult) {
        this.groupField = groupField;
        this.collectors = Maps.newLinkedHashMap();
        ImmutableList.Builder resultsBuilder = ImmutableList.builder();
        for (String group : firstPassResult.getGroups()) {
            if (group == null) continue;
            GroupValueCollector collector = new GroupValueCollector(group);
            this.collectors.put(group, collector);
            resultsBuilder.add((Object)collector);
        }
        this.groupResults = resultsBuilder.build();
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.leafReader = context.reader();
        this.docValues = DocValues.getSorted((LeafReader)this.leafReader, (String)this.groupField);
        this.orderedCollectors = Maps.newLinkedHashMap();
        for (GroupValueCollector group : this.collectors.values()) {
            group.docsCollector.doSetNextReader(context);
            this.orderedCollectors.put(this.docValues.lookupTerm(new BytesRef((CharSequence)group.groupKey)), group);
        }
    }

    public void collect(int doc) throws IOException {
        GroupValueCollector group;
        if (doc >= 0 && doc < this.leafReader.maxDoc() && this.docValues.advanceExact(doc) && (group = this.orderedCollectors.get(this.docValues.ordValue())) != null) {
            group.docsCollector.collect(doc);
        }
    }

    public boolean needsScores() {
        return false;
    }

    public List<GroupResult> getResults() {
        return this.groupResults;
    }

    private static class GroupValueCollector
    implements GroupResult {
        private final String groupKey;
        private final AllDocsCollector73 docsCollector;

        GroupValueCollector(String groupKey) {
            this.groupKey = groupKey;
            this.docsCollector = new AllDocsCollector73();
        }

        @Override
        public String getGroupKey() {
            return this.groupKey;
        }

        @Override
        public Set<Integer> getGroupDocs() {
            return this.docsCollector.getDocs();
        }

        @Override
        public int totalHits() {
            return this.docsCollector.getDocs().size();
        }
    }
}

