/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpLogging;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.ApacheUtils;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.linear.LinearConstraint;
import org.apache.commons.math3.optim.linear.LinearConstraintSet;
import org.apache.commons.math3.optim.linear.LinearObjectiveFunction;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.NonNegativeConstraint;
import org.apache.commons.math3.optim.linear.Relationship;
import org.apache.commons.math3.optim.linear.SimplexSolver;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;

public class FinishableTest {
    public static boolean isFinishable(PositivePrimitivesMap<IResourceType> limitedRequiredWork, PositivePrimitivesMap<IMutableResource> limitedResourceAvailabilities) {
        SimplexSolver solver = new SimplexSolver();
        OptimizationData[] optData = FinishableTest.createOptData(limitedRequiredWork, limitedResourceAvailabilities);
        LpLogging.logDebug(optData);
        try {
            solver.optimize(optData);
        }
        catch (NoFeasibleSolutionException e) {
            return false;
        }
        return true;
    }

    private static OptimizationData[] createOptData(PositivePrimitivesMap<IResourceType> limitedRequiredWork, PositivePrimitivesMap<IMutableResource> limitedResourceAvailabilities) {
        ArrayList optData = Lists.newArrayList();
        optData.add(GoalType.MAXIMIZE);
        Set<IResourceType> requiredTypes = limitedRequiredWork.keySet();
        int index = 0;
        HashMap resourceIndices = Maps.newHashMap();
        HashMap typeIndices = Maps.newHashMap();
        for (IMutableResource resource : limitedResourceAvailabilities.keySet()) {
            Set<IResourceType> resourceTypes = resource.getResourceTypes();
            for (IResourceType resourceType : Sets.intersection(resourceTypes, requiredTypes)) {
                RmUtils.addToKeyedSets(typeIndices, resourceType, index);
                RmUtils.addToKeyedSets(resourceIndices, resource, index);
                ++index;
            }
        }
        HashSet constraints = Sets.newHashSet();
        Set<LinearConstraint> availabilityConstraints = ApacheUtils.createLinearConstraintsForLimits(resourceIndices, limitedResourceAvailabilities, index, Relationship.LEQ);
        constraints.addAll(availabilityConstraints);
        Set<LinearConstraint> demandConstraints = ApacheUtils.createLinearConstraintsForLimits(typeIndices, limitedRequiredWork, index, Relationship.GEQ);
        constraints.addAll(demandConstraints);
        optData.add(new LinearConstraintSet(constraints));
        optData.add(new LinearObjectiveFunction(new double[index], 0.0));
        optData.add(new NonNegativeConstraint(true));
        return optData.toArray(new OptimizationData[optData.size()]);
    }
}

