/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.ItemNotSchedulableException;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.ReachedPlanningHorizonException;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.EnforcedUnstructuredItemScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.IUnstructuredItemSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.ItemSchedulingState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.PartialUnstructuredItemStageProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.UnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.IUnstructuredStageSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.UnstructuredStageScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingStageWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.IWorkAssignable;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.util.RmSchedulingUtils;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.javasimon.Stopwatch;

@Immutable
public class EnforcedUnstructuredScheduler
implements EnforcedUnstructuredItemScheduler {
    private static final Log LOGGER = Log.with(EnforcedUnstructuredScheduler.class);
    private final IUnstructuredStageSolver unstructuredStageSolver;

    public EnforcedUnstructuredScheduler(CancellationState cancellationState) {
        this(new UnstructuredStageScheduler(cancellationState));
    }

    EnforcedUnstructuredScheduler(IUnstructuredStageSolver unstructuredStageScheduler) {
        this.unstructuredStageSolver = unstructuredStageScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IUnstructuredItemSchedule schedule(IUnstructuredItemSchedulingProblem problem) throws ItemNotSchedulableException, InterruptedException, ReachedPlanningHorizonException {
        Stopwatch stopwatch = SimonManager.getStopwatch("calculation.epic");
        Split split = stopwatch.start();
        HashSet neededStages = Sets.newHashSet(problem.getProcessingItem().getWorkDemand().getSpecifiedStages());
        try {
            Optional<IUnstructuredItemSchedule> schedule;
            PartialUnstructuredItemStageProblem nextStageProblem;
            ItemSchedulingState problemState = ItemSchedulingState.createInstance(problem);
            Set<IMutableResourcePool> resourcePools = problem.getMutableResourcePools();
            List<IMutableResourcePool> pools = RmSortableUtils.sort(resourcePools);
            HashSet partialSchedules = Sets.newHashSet();
            HashSet empty = Sets.newHashSet();
            while ((nextStageProblem = (PartialUnstructuredItemStageProblem)problemState.getNextStageSchedulingProblem(empty).orNull()) != null) {
                IWorkAssignable bestFit = null;
                IMutableResourcePool bestPool = null;
                for (IMutableResourcePool pool : pools) {
                    Optional<IUnstructuredItemSchedule> schedule2 = this.unstructuredStageSolver.trySolveNextStageProblemForGroup(nextStageProblem, pool, (IUnstructuredItemSchedule)bestFit);
                    if (!this.isFirstScheduleSuperiorToSecond(nextStageProblem, (IUnstructuredItemSchedule)schedule2.orNull(), (IUnstructuredItemSchedule)bestFit)) continue;
                    bestFit = (IUnstructuredItemSchedule)schedule2.get();
                    bestPool = pool;
                }
                if (bestFit != null) {
                    partialSchedules.add(bestFit);
                    bestPool.getMutableResourceGroup().schedule(bestFit.getWorkAssignments());
                    IProcessingStageWorkPackage doneWork = (IProcessingStageWorkPackage)bestFit.getAggregatedWorkPackage().getWorkPackageForStage(nextStageProblem.getProcessingStage()).get();
                    IWorkAssignable workInterval = bestFit;
                    problemState.updateProblemState(doneWork, (IIntegerInterval)((Object)workInterval));
                    continue;
                }
                Optional<IUnstructuredItemSchedule> schedule3 = UnstructuredItemSchedule.tryCreateFromPartialSchedules(neededStages, partialSchedules, false);
                if (problem.isUpperTimeBoundPlanningHorizon() && RmSchedulingUtils.hasUnlimitedResource(problem.getMutableResourcePools())) {
                    throw new ReachedPlanningHorizonException(problem.getId(), (IUnstructuredItemSchedule)schedule3.orNull());
                }
                throw new ItemNotSchedulableException(problem.getId(), (IUnstructuredItemSchedule)schedule3.orNull());
            }
            if (!problemState.isItemFinished()) {
                schedule = UnstructuredItemSchedule.tryCreateFromPartialSchedules(neededStages, partialSchedules, false);
                if (problem.isUpperTimeBoundPlanningHorizon()) {
                    throw new ReachedPlanningHorizonException(problem.getId(), (IUnstructuredItemSchedule)schedule.orNull());
                }
                throw new ItemNotSchedulableException(problem.getId(), (IUnstructuredItemSchedule)schedule.orNull());
            }
            schedule = UnstructuredItemSchedule.createDoneFromPartialSchedules(Sets.newHashSet(), partialSchedules);
            LogUtil.debug(LOGGER, "return schedule: %s", schedule);
            Optional<IUnstructuredItemSchedule> optional = schedule;
            return optional;
        }
        finally {
            split.stop();
        }
    }

    private boolean isFirstScheduleSuperiorToSecond(PartialUnstructuredItemStageProblem nextStageProblem, IUnstructuredItemSchedule schedule, IUnstructuredItemSchedule bestIterationSchedule) {
        if (schedule == null) {
            return false;
        }
        if (bestIterationSchedule == null) {
            return true;
        }
        float minimumWorkLoad = nextStageProblem.getMinimumWorkLoad();
        float scheduleSum = schedule.getAggregatedWorkPackage().getPositiveTypeAmounts().getValueSum();
        float bestIterationScheduleSum = bestIterationSchedule.getAggregatedWorkPackage().getPositiveTypeAmounts().getValueSum();
        if (scheduleSum < minimumWorkLoad && bestIterationScheduleSum >= minimumWorkLoad) {
            return false;
        }
        if (bestIterationScheduleSum < minimumWorkLoad && scheduleSum >= minimumWorkLoad) {
            return true;
        }
        return schedule.getEnd() < bestIterationSchedule.getEnd();
    }
}

