/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.apache;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.IUnstructuredStageLpProblemSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.apache.ApacheUnstructStageOptDataCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.unstruct.stage.lp.IUnstructuredStageLpProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpLogging;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import java.util.Arrays;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.NoFeasibleSolutionException;
import org.apache.commons.math3.optim.linear.SimplexSolver;

public class ApacheUnstructuredStageSolver
implements IUnstructuredStageLpProblemSolver {
    private static final Log LOGGER = Log.with(ApacheUnstructuredStageSolver.class);
    private final SimplexSolver simlexSolver;
    private final ApacheUnstructStageOptDataCreator optDataCreator;
    private final CancellationState cancellationState;

    ApacheUnstructuredStageSolver(SimplexSolver simlexSolver, ApacheUnstructStageOptDataCreator optDataCreator, CancellationState cancellationState) {
        this.simlexSolver = simlexSolver;
        this.optDataCreator = optDataCreator;
        this.cancellationState = cancellationState;
    }

    public ApacheUnstructuredStageSolver(CancellationState cancellationState) {
        this(new SimplexSolver(), new ApacheUnstructStageOptDataCreator(), cancellationState);
    }

    @Override
    public Optional<float[]> trySolve(IUnstructuredStageLpProblem problem) throws InterruptedException {
        LogUtil.debug(LOGGER, "solve problem: %s", problem);
        if (this.cancellationState.isCancelled()) {
            throw new InterruptedException();
        }
        try {
            OptimizationData[] optData = this.optDataCreator.createOptimizationData(problem);
            LpLogging.logDebug(optData);
            PointValuePair solution = this.simlexSolver.optimize(optData);
            LogUtil.debug(LOGGER, "solution: %s", solution);
            float[] lpSolution = RmUtils.toFloatArray((double[])solution.getFirst());
            LogUtil.debug(LOGGER, "\nLP solution: " + Arrays.toString(lpSolution));
            return Optional.of((Object)lpSolution);
        }
        catch (NoFeasibleSolutionException e) {
            LogUtil.debug(LOGGER, "no feasible solution found for problem: %s", problem);
            return Optional.absent();
        }
    }
}

