/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidate;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentCandidateSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.AssignmentFringe;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.SearchBasedSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.search.SearchCandidateTransformation;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.atlassian.rm.jpo.scheduling.util.search.FirstSolutionTreeSearch;
import com.atlassian.rm.jpo.scheduling.util.search.InterruptableFunction;
import com.google.common.base.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public class DefaultSearchBasedSolver
implements SearchBasedSolver {
    private static final Log LOGGER = Log.with(DefaultSearchBasedSolver.class);
    private final FirstSolutionTreeSearch<AssignmentCandidate, AssignmentCandidateSolution> treeSearch;
    private final InterruptableFunction<AssignmentCandidate, AssignmentCandidateSolution> assignmentCandidateTransformer;

    public DefaultSearchBasedSolver(CancellationState cancellationState) {
        this(new FirstSolutionTreeSearch<AssignmentCandidate, AssignmentCandidateSolution>(), new SearchCandidateTransformation(cancellationState));
    }

    DefaultSearchBasedSolver(FirstSolutionTreeSearch<AssignmentCandidate, AssignmentCandidateSolution> treeSearch, InterruptableFunction<AssignmentCandidate, AssignmentCandidateSolution> assignmentCandidateTransformer) {
        this.treeSearch = treeSearch;
        this.assignmentCandidateTransformer = assignmentCandidateTransformer;
    }

    @Override
    public Optional<AssignmentCandidateSolution> tryFindSolution(AssignmentFringe fringe) throws InterruptedException {
        LogUtil.debug(LOGGER, "try find solution with fringe: %s", fringe);
        Optional<AssignmentCandidateSolution> solution = this.treeSearch.tryFindFirstSolution(fringe, this.assignmentCandidateTransformer);
        return solution;
    }

    public String toString() {
        return "DefaultSearchBasedSolver [treeSearch=" + this.treeSearch + "]";
    }
}

