/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.generator.rand.time;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.generator.GeneratorUtils;
import com.radiantminds.roadmap.common.data.generator.rand.time.IRandomizedTimePlanConfiguration;
import com.radiantminds.roadmap.common.data.generator.rand.time.ITimePlanConfigurationCreator;
import com.radiantminds.roadmap.common.data.generator.time.ITimePlanConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.ReleaseConfiguration;
import com.radiantminds.roadmap.common.data.generator.time.TimePlanConfiguration;
import java.util.ArrayList;
import java.util.Random;
import org.joda.time.DateTime;

public class TimePlanConfigurationCreator
implements ITimePlanConfigurationCreator {
    private static final String RELEASE_PREFIX = "release-";

    @Override
    public ITimePlanConfiguration createConfiguration(IRandomizedTimePlanConfiguration timePlanConfiguration, Random random) {
        ArrayList releaseConfigurations = Lists.newArrayList();
        int releasesCount = timePlanConfiguration.getReleasesCount();
        int durationSumInDays = 0;
        DateTime startDate = timePlanConfiguration.getStartDate();
        for (int releaseIndex = 0; releaseIndex < releasesCount; ++releaseIndex) {
            ReleaseConfiguration releaseConfiguration;
            String title = RELEASE_PREFIX + releaseIndex;
            int durationInDays = GeneratorUtils.getRandomFromInterval(timePlanConfiguration.getMinReleaseDurationInDays(), timePlanConfiguration.getMaxReleaseDurationInDays(), random);
            DateTime endDate = startDate.plusDays(durationSumInDays += durationInDays);
            if (releaseIndex == 0) {
                releaseConfiguration = new ReleaseConfiguration.Builder(title).withStartDate(startDate).withEndDate(endDate).build();
                releaseConfigurations.add(releaseConfiguration);
                continue;
            }
            releaseConfiguration = new ReleaseConfiguration.Builder(title).withEndDate(endDate).build();
            releaseConfigurations.add(releaseConfiguration);
        }
        TimePlanConfiguration configuration = TimePlanConfiguration.createWithSingleStream(releaseConfigurations);
        return configuration;
    }
}

