/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select.EstimationTargetType;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class EstimationDataBlock {
    private final double estimate;
    private final Boolean original;
    private final Boolean replanning;
    private final int targetId;
    private final EstimationTargetType targetType;

    public EstimationDataBlock(double estimate, int targetId, EstimationTargetType targetType, @Nullable Boolean original, @Nullable Boolean replanning) {
        Preconditions.checkNotNull((Object)targetType, (Object)"target type must not be null");
        this.estimate = estimate;
        this.original = original;
        this.replanning = replanning;
        this.targetId = targetId;
        this.targetType = targetType;
    }

    double getEstimate() {
        return this.estimate;
    }

    Optional<Boolean> getOriginal() {
        return Optional.fromNullable((Object)this.original);
    }

    Optional<Boolean> getReplanning() {
        return Optional.fromNullable((Object)this.replanning);
    }

    int getTargetId() {
        return this.targetId;
    }

    EstimationTargetType getTargetType() {
        return this.targetType;
    }

    public String toString() {
        return "EstimationDataBlock [estimate=" + this.estimate + ", original=" + this.original + ", replanning=" + this.replanning + ", targetId=" + this.targetId + ", targetType=" + this.targetType + "]";
    }
}

