/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.sql.select;

import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.filter.IWorkItemFilter;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

final class FilterHelper {
    FilterHelper() {
    }

    public static void addTitleFilter(List<String> workItemLevels, IWorkItemFilter filter, AOQueryGenerator generator) {
        if (filter.getFullTextFilterString() == null) {
            return;
        }
        String text = filter.getFullTextFilterString().toLowerCase();
        generator.and().raw("(");
        for (int i = 0; i < workItemLevels.size(); ++i) {
            if (i > 0) {
                generator.or();
            }
            generator.lowerCase().raw("(").col(workItemLevels.get(i), "title").raw(")").like(text);
        }
        generator.raw(")");
    }

    public static void addDateRangeFilter(List<String> workItemLevels, Collection<String> greenDataWorkItemIds, AOQueryGenerator generator) throws SQLException {
        if (greenDataWorkItemIds == null) {
            return;
        }
        if (greenDataWorkItemIds.isEmpty()) {
            greenDataWorkItemIds.add("-1");
        }
        generator.and().raw("(");
        for (int i = 0; i < workItemLevels.size(); ++i) {
            if (i > 0) {
                generator.or();
            }
            final String hierarchyLevel = workItemLevels.get(i);
            generator.raw("(").inNumeric(new AOQueryGenerator.InOperandCallback(){

                @Override
                public void generateOperand(AOQueryGenerator generator) {
                    generator.colId(hierarchyLevel);
                }
            }, greenDataWorkItemIds).raw(")");
        }
        generator.raw(")");
    }

    public static void addRelationFilter(String column, List<String> workItemLevels, Collection<String> blackDataValues, Collection<String> greenDataWorkItemIds, AOQueryGenerator generator) throws SQLException {
        if (FilterHelper.isNullOrEmpty(blackDataValues) && FilterHelper.isNullOrEmpty(greenDataWorkItemIds)) {
            return;
        }
        generator.and().raw("(");
        if (!FilterHelper.isNullOrEmpty(blackDataValues)) {
            if ("aoTheme".equals(column)) {
                FilterHelper.addThemeRelationFilter(blackDataValues, workItemLevels, generator);
            } else {
                FilterHelper.addNonThemeRelationFilter(column, workItemLevels, blackDataValues, generator);
            }
        }
        if (!FilterHelper.isNullOrEmpty(greenDataWorkItemIds)) {
            if (!FilterHelper.isNullOrEmpty(blackDataValues)) {
                generator.or();
            }
            for (int i = 0; i < workItemLevels.size(); ++i) {
                if (i > 0) {
                    generator.or();
                }
                final String hierarchyLevel = workItemLevels.get(i);
                generator.raw("(").col(hierarchyLevel, column).isNull().and().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colId(hierarchyLevel);
                    }
                }, greenDataWorkItemIds).raw(")");
            }
        }
        generator.raw(")");
    }

    private static void addNonThemeRelationFilter(final String column, List<String> workItemLevels, Collection<String> blackDataValues, AOQueryGenerator generator) throws SQLException {
        for (int i = 0; i < workItemLevels.size(); ++i) {
            if (i > 0) {
                generator.or();
            }
            final String hierarchyLevel = workItemLevels.get(i);
            generator.raw("(").col(hierarchyLevel, column).isNotNull().and().inNumeric(new AOQueryGenerator.InOperandCallback(){

                @Override
                public void generateOperand(AOQueryGenerator generator) {
                    generator.col(hierarchyLevel, column);
                }
            }, blackDataValues).raw(")");
        }
    }

    private static void addThemeRelationFilter(Collection<String> blackDataValues, List<String> workItemLevels, AOQueryGenerator generator) throws SQLException {
        boolean filteredForNoTheme = blackDataValues.contains("-1");
        for (int i = 0; i < workItemLevels.size(); ++i) {
            if (i > 0) {
                generator.or();
            }
            FilterHelper.addChildlessClause(workItemLevels, generator, i);
            final String hierarchyLevel = workItemLevels.get(i);
            if (!filteredForNoTheme) {
                generator.raw("(").col(hierarchyLevel, "aoTheme").isNotNull().and().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.col(hierarchyLevel, "aoTheme");
                    }
                }, blackDataValues).raw(")");
            } else {
                generator.raw("(").col(hierarchyLevel, "aoTheme").isNull().or().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.col(hierarchyLevel, "aoTheme");
                    }
                }, blackDataValues).raw(")");
            }
            generator.raw(")");
        }
    }

    private static void addChildlessClause(List<String> workItemLevels, AOQueryGenerator generator, int level) {
        if (level < workItemLevels.size() - 1) {
            generator.raw("(").raw("(").raw("(").colId(workItemLevels.get(level + 1)).isNull().and().colId(workItemLevels.get(level)).isNotNull().raw(")").raw(")").and();
        } else {
            generator.raw("(").raw("(").colId(workItemLevels.get(level)).isNotNull().raw(")").and();
        }
    }

    private static boolean isNullOrEmpty(Collection<String> it) {
        return it == null || it.isEmpty();
    }
}

