/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.permissions;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.radiantminds.roadmap.common.data.entities.permissions.IPermission;
import com.radiantminds.roadmap.common.data.entities.plans.IPlan;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioPermissionPersistence;
import com.radiantminds.roadmap.common.extensions.users.UserData;
import com.radiantminds.roadmap.common.extensions.users.UserExtension;
import com.radiantminds.roadmap.common.permissions.PlanPermission;
import com.radiantminds.roadmap.common.permissions.PlanPermissionAuthentication;
import com.radiantminds.roadmap.common.permissions.PlanPermissionCheckResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PlanPermissions {
    private final PortfolioPermissionPersistence permissionPersistence;
    private final UserExtension userExtension;

    @Autowired
    public PlanPermissions(PortfolioPermissionPersistence permissionPersistence, UserExtension userExtension) {
        this.permissionPersistence = permissionPersistence;
        this.userExtension = userExtension;
    }

    public PlanPermissionCheckResult check(String planId, PlanPermission ... planPermissions) throws Exception {
        List<IPermission> permissions = this.getSecuredPermissions(this.userExtension, planId);
        return this.checkOrInternal(permissions, planPermissions);
    }

    public <T extends IPlan> Map<String, Collection<PlanPermission>> getPlanPermissions(List<T> plans) throws Exception {
        HashMap retVal = Maps.newHashMap();
        for (IPlan plan : plans) {
            retVal.put(plan.getId(), this.getPlanPermissions(plan.getId()));
        }
        return retVal;
    }

    public Collection<PlanPermission> getPlanPermissions(String planId) throws Exception {
        List<IPermission> permissions = this.getSecuredPermissions(this.userExtension, planId);
        PlanPermissionCheckResult results = this.checkOrInternal(permissions, new PlanPermission[]{PlanPermission.Editor, PlanPermission.Viewer});
        return results.getValidPermissions();
    }

    public List<IPermission> getSecuredPermissions(@Nullable UserExtension userExtension, String targetId) throws SQLException {
        List<IPermission> permissions = this.permissionPersistence.getPermissionsCached("plan", targetId);
        if (userExtension != null) {
            permissions = userExtension.removeMissingEntries(permissions);
        }
        return permissions;
    }

    public PlanPermissionCheckResult check(List<IPermission> permissions, PlanPermission ... planPermissions) {
        return this.checkOrInternal(permissions, planPermissions);
    }

    private PlanPermissionCheckResult checkOrInternal(List<IPermission> permissions, PlanPermission[] planPermissions) {
        if (planPermissions.length == 0) {
            throw new IllegalArgumentException();
        }
        UserData userData = this.userExtension.getActiveUserData();
        HashMap retVal = Maps.newHashMap();
        for (final PlanPermission planPermission : planPermissions) {
            ArrayList filteredPermissions = Lists.newArrayList((Iterable)Iterables.filter(permissions, (Predicate)new Predicate<IPermission>(){

                public boolean apply(@Nullable IPermission permission) {
                    return planPermission.getPermissionNumber().equals(permission.getPermission());
                }
            }));
            PlanPermissionAuthentication authentication = PlanPermissions.check(userData, filteredPermissions);
            retVal.put(planPermission, authentication);
        }
        return new PlanPermissionCheckResult(retVal);
    }

    private static PlanPermissionAuthentication check(UserData userData, List<IPermission> permissions) {
        if (permissions.size() == 0) {
            return PlanPermissionAuthentication.CheckPluginPermissions;
        }
        for (IPermission permission : permissions) {
            if (!("user".equals(permission.getHolderType()) ? userData.getUserID().equals(permission.getHolderId()) : "group".equals(permission.getHolderType()) && userData.getGroupIDs().contains(permission.getHolderId()))) continue;
            return PlanPermissionAuthentication.Authorized;
        }
        return PlanPermissionAuthentication.Denied;
    }
}

