/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.entities.scheduling;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingRelease;
import com.radiantminds.roadmap.common.data.entities.releases.SchedulingStream;
import com.radiantminds.roadmap.common.rest.entities.scheduling.RestReleaseEntry;
import com.radiantminds.roadmap.common.scheduling.retrafo.solution.IPlanSolution;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="release")
@XmlAccessorType(value=XmlAccessType.NONE)
public class RestStreamEntry {
    @XmlElement
    private String id;
    @XmlElement
    private List<RestReleaseEntry> releases;

    protected RestStreamEntry() {
    }

    public RestStreamEntry(String id, List<RestReleaseEntry> releases) {
        this.id = id;
        this.releases = releases;
    }

    public List<RestReleaseEntry> getReleases() {
        return this.releases;
    }

    public static Function<SchedulingStream, RestStreamEntry> createFromFunction(final IPlanSolution planSolution) {
        return new Function<SchedulingStream, RestStreamEntry>(){

            public RestStreamEntry apply(SchedulingStream stream) {
                Iterable restReleaseEntries = Iterables.transform((Iterable)RestStreamEntry.getAllReleasesForStream(stream), RestReleaseEntry.createFromFunction(planSolution));
                ArrayList restReleases = Lists.newArrayList((Iterable)Iterables.filter((Iterable)restReleaseEntries, (Predicate)Predicates.notNull()));
                return new RestStreamEntry(stream.getId(), restReleases);
            }
        };
    }

    private static List<? extends SchedulingRelease> getAllReleasesForStream(SchedulingStream stream) {
        ArrayList releases = Lists.newArrayList();
        releases.addAll(stream.getReleases());
        releases.add(stream.getLaterRelease());
        return releases;
    }
}

