/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.stages;

import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.entities.skills.IStage;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioExtensionLinkPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioSkillPersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioStagePersistence;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.data.persistence.services.PortfolioPlanPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.SecuredInvocationHandlerFactory;
import com.radiantminds.roadmap.common.rest.entities.common.RestPercentage;
import com.radiantminds.roadmap.common.rest.entities.common.RestRank;
import com.radiantminds.roadmap.common.rest.entities.skills.RestSkill;
import com.radiantminds.roadmap.common.rest.entities.skills.RestStage;
import com.radiantminds.roadmap.common.rest.services.common.BaseOperationsService;
import com.radiantminds.roadmap.common.rest.services.stages.StageServiceHandler;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/stages")
@Component
public class StageService
extends BaseOperationsService<IStage, RestStage> {
    private final StageServiceHandler handler;

    @Autowired
    public StageService(SecuredInvocationHandlerFactory handlerFactory, ActiveObjectsUtilities activeObjectsUtilities, PortfolioPlanPersistence planPersistence, PortfolioWorkItemPersistence workItemPersistence, PortfolioStagePersistence stagePersistence, PortfolioSkillPersistence skillPersistence, PortfolioExtensionLinkPersistence extensionLinkPersistence) {
        super(RestStage.class, stagePersistence, handlerFactory);
        this.handler = handlerFactory.createProxy(StageServiceHandler.class, new StageServiceHandler.Impl(activeObjectsUtilities, skillPersistence, stagePersistence, planPersistence, workItemPersistence, extensionLinkPersistence), stagePersistence);
    }

    @Override
    protected RestStage transform(IStage entity, boolean includeReplanningData) {
        return new RestStage(entity);
    }

    @Override
    protected Response update(RestStage source, IStage target, boolean allowNull) {
        this.updateCommons(source, target, allowNull);
        if (allowNull || source.getColor() != null) {
            target.setColor(source.getColor());
        }
        return null;
    }

    @Override
    @DELETE
    @Path(value="{id}")
    public Response entryDelete(@PathParam(value="id") String id, @QueryParam(value="version") Long version, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.handler.entryDelete(EntityContext.from(id, version, expectedPlanVersion, clientId));
    }

    @PUT
    @Path(value="{id}/percentage")
    public Response setPercentage(@PathParam(value="id") String id, RestPercentage value, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId) throws Exception {
        return this.handler.setPercentage(EntityContext.from(id, expectedPlanVersion, clientId), value.getValue());
    }

    @GET
    @Path(value="{id}/skills")
    public Response getAllSkills(@PathParam(value="id") String stageId, @QueryParam(value="planVersion") Long expectedPlanVersion) throws Exception {
        return this.handler.getAllSkills(EntityContext.from(stageId, expectedPlanVersion));
    }

    @POST
    @Path(value="{id}/skills")
    public Response addSkillToStage(@PathParam(value="id") String stageId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestSkill newSkill) throws Exception {
        return this.handler.addSkillToStage(EntityContext.from(stageId, expectedPlanVersion, clientId), newSkill);
    }

    @PUT
    @Path(value="{id}/skills/rank")
    public Response rankSkill(@PathParam(value="id") String stageId, @QueryParam(value="planVersion") Long expectedPlanVersion, @QueryParam(value="clientId") String clientId, RestRank rank) throws Exception {
        return this.handler.rankSkill(EntityContext.from(stageId, expectedPlanVersion, clientId), rank);
    }
}

