/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.trafo.teams;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.TimeStepPresenceFunction;
import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.data.entities.plans.SchedulingPlan;
import com.radiantminds.roadmap.common.scheduling.common.ITimeTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.settings.IResourceTypeMapping;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.BaseTeamsTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.kanban.KanbanTeamTransformer;
import com.radiantminds.roadmap.common.scheduling.trafo.teams.scrum.ScrumTeamTransformer;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TimeBasedTeamsTransformer
extends BaseTeamsTransformer {
    private final KanbanTeamTransformer kanbanTeamCreator;
    private final ScrumTeamTransformer scrumTeamTransformer;

    public TimeBasedTeamsTransformer(ITimeTransformer timeTransformer, TimeStepPresenceFunction timeStepPresenceFunction) {
        this(new KanbanTeamTransformer(timeTransformer, timeStepPresenceFunction), new ScrumTeamTransformer(timeTransformer, timeStepPresenceFunction));
    }

    TimeBasedTeamsTransformer(KanbanTeamTransformer kanbanTeamCreator, ScrumTeamTransformer scrumTeamTransformer) {
        this.kanbanTeamCreator = kanbanTeamCreator;
        this.scrumTeamTransformer = scrumTeamTransformer;
    }

    @Override
    protected Optional<IResourceGroup> tryGetResourceGroup(IResourceTypeMapping resourceTypeMapping, SchedulingTeam team, SchedulingPlan plan) {
        if (PlanningMode.Scrum.equals((Object)team.getPlanningMode())) {
            return this.scrumTeamTransformer.tryCreateResourceGroup(team, resourceTypeMapping, plan);
        }
        if (PlanningMode.Kanban.equals((Object)team.getPlanningMode())) {
            return this.kanbanTeamCreator.tryCreateResourceGroup(team, resourceTypeMapping, plan);
        }
        return Optional.absent();
    }
}

