/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.PeriodAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.Sampling;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.math.LongMath;
import com.google.common.primitives.Floats;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.uncommons.maths.combinatorics.CombinationGenerator;

public class SetCoverSampling
implements Sampling {
    private static final int BATCH_SIZE = 100;
    private final Random random;
    private final int batchSize;

    SetCoverSampling() {
        this(new Random(123321123321L), 100);
    }

    SetCoverSampling(Random random, int batchSize) {
        this.batchSize = batchSize;
        this.random = random;
    }

    @Override
    public int[][] selectResourcesBatch(int activity, float[] availabilities, PeriodAssignmentProblem problem) {
        Set<Integer> possibleResources = problem.getPossibleResourcesForActivity(activity);
        if (possibleResources.isEmpty()) {
            return new int[0][0];
        }
        if (possibleResources.size() < problem.getAssignedResourcesLimit(activity)) {
            return new int[][]{this.toIntArray(possibleResources)};
        }
        long count = LongMath.binomial((int)possibleResources.size(), (int)problem.getAssignedResourcesLimit(activity));
        if (count > (long)this.batchSize) {
            return new int[][]{this.availabilityBasedSampling(activity, possibleResources, availabilities, problem), this.skill(activity, possibleResources, problem)};
        }
        return this.createAllCombinations(possibleResources, problem.getAssignedResourcesLimit(activity));
    }

    private int[] availabilityBasedSampling(int activity, Set<Integer> possibleResources, float[] availabilities, PeriodAssignmentProblem problem) {
        HashSet covered = Sets.newHashSet();
        HashSet selected = Sets.newHashSet();
        float maxPlusOffset = Floats.max((float[])availabilities) + 1.0f;
        for (int i = 0; i < problem.getAssignedResourcesLimit(activity); ++i) {
            int select = -1;
            float bestCost = Float.MAX_VALUE;
            Sets.SetView openSkills = Sets.difference(problem.getNeededSkills(activity), (Set)covered);
            UnmodifiableIterator unmodifiableIterator = Sets.difference(possibleResources, (Set)selected).iterator();
            while (unmodifiableIterator.hasNext()) {
                Sets.SetView newlyCoveredByResource;
                int resource = (Integer)unmodifiableIterator.next();
                float resourceCost = (maxPlusOffset - availabilities[resource]) / Math.max(0.01f, (float)(newlyCoveredByResource = Sets.intersection(problem.getAvailableSkills(resource), (Set)openSkills)).size());
                if (resourceCost < bestCost) {
                    select = resource;
                    bestCost = resourceCost;
                    continue;
                }
                if (resourceCost != bestCost || !this.random.nextBoolean()) continue;
                select = resource;
            }
            selected.add(select);
            covered.addAll(problem.getAvailableSkills(select));
        }
        return this.toIntArray(selected);
    }

    private int[] skill(int activity, Set<Integer> possibleResources, PeriodAssignmentProblem problem) {
        HashSet covered = Sets.newHashSet();
        HashSet selected = Sets.newHashSet();
        for (int i = 0; i < problem.getAssignedResourcesLimit(activity); ++i) {
            int select = -1;
            float bestCost = Float.MAX_VALUE;
            Sets.SetView openSkills = Sets.difference(problem.getNeededSkills(activity), (Set)covered);
            UnmodifiableIterator unmodifiableIterator = Sets.difference(possibleResources, (Set)selected).iterator();
            while (unmodifiableIterator.hasNext()) {
                int resource = (Integer)unmodifiableIterator.next();
                Sets.SetView newlyCoveredByResource = Sets.intersection(problem.getAvailableSkills(resource), (Set)openSkills);
                float resourceCost = 1.0f / Math.max(0.01f, (float)newlyCoveredByResource.size());
                if (resourceCost < bestCost) {
                    select = resource;
                    bestCost = resourceCost;
                    continue;
                }
                if (resourceCost != bestCost || !this.random.nextBoolean()) continue;
                select = resource;
            }
            selected.add(select);
            covered.addAll(problem.getAvailableSkills(select));
        }
        return this.toIntArray(selected);
    }

    private int[][] createAllCombinations(Set<Integer> possibleResources, int assignedResourcesLimit) {
        CombinationGenerator<Integer> generator = new CombinationGenerator<Integer>(possibleResources, assignedResourcesLimit);
        int[][] combinations = new int[(int)generator.getTotalCombinations()][assignedResourcesLimit];
        for (int i = 0; i < combinations.length; ++i) {
            List<Integer> unmunged = Arrays.asList(generator.nextCombinationAsArray());
            combinations[i] = this.toIntArray(unmunged);
        }
        return combinations;
    }

    private int[] toIntArray(Collection<Integer> resources) {
        int[] array = new int[resources.size()];
        int i = 0;
        for (int r : resources) {
            array[i++] = r;
        }
        return array;
    }
}

