/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.rank;

import com.atlassian.greenhopper.model.lexorank.LexoRank;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldServiceBridge;
import com.atlassian.rm.common.bridges.agile.customfields.AgileCustomFieldsServiceBridgeProxy;
import com.atlassian.rm.common.bridges.agile.rank.IssueRankExtractor;
import com.google.common.base.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.rank.IssueRankExtractorFactory")
public class IssueRankExtractorFactory {
    private static final Log LOGGER = Log.with(IssueRankExtractorFactory.class);
    private final AgileCustomFieldsServiceBridgeProxy agileCustomFieldsServiceBridgeProxy;

    @Autowired
    IssueRankExtractorFactory(AgileCustomFieldsServiceBridgeProxy agileCustomFieldsServiceBridgeProxy) {
        this.agileCustomFieldsServiceBridgeProxy = agileCustomFieldsServiceBridgeProxy;
    }

    public IssueRankExtractor createExtractor() {
        Optional<CustomField> lexoRankField = this.getRankField(this.agileCustomFieldsServiceBridgeProxy);
        if (!lexoRankField.isPresent()) {
            return new AbsentRankExtractor();
        }
        return new FieldRankExtractor((CustomField)lexoRankField.get());
    }

    private Optional<CustomField> getRankField(AgileCustomFieldsServiceBridgeProxy proxy) {
        try {
            return Optional.fromNullable((Object)((AgileCustomFieldServiceBridge)proxy.get()).getRankField());
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to get rank field from Agile. Ignoring rank for extraction.", new Object[0]);
            return Optional.absent();
        }
    }

    private static class AbsentRankExtractor
    implements IssueRankExtractor {
        private AbsentRankExtractor() {
        }

        @Override
        public Optional<String> extract(Issue issue) {
            return Optional.absent();
        }
    }

    private static class FieldRankExtractor
    implements IssueRankExtractor {
        private final CustomField lexoRankField;

        FieldRankExtractor(CustomField lexoRankField) {
            this.lexoRankField = lexoRankField;
        }

        @Override
        public Optional<String> extract(Issue issue) {
            LexoRank rank = (LexoRank)issue.getCustomFieldValue(this.lexoRankField);
            if (rank == null) {
                return Optional.absent();
            }
            return Optional.fromNullable((Object)rank.format());
        }
    }
}

