/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types.expr;

import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;
import com.mysema.query.types.Path;
import com.mysema.query.types.PathImpl;
import com.mysema.query.types.expr.DateOperation;
import com.mysema.query.types.expr.NumberExpression;
import com.mysema.query.types.expr.NumberOperation;
import com.mysema.query.types.expr.TemporalExpression;
import java.util.Date;
import javax.annotation.Nullable;

public abstract class DateExpression<T extends Comparable>
extends TemporalExpression<T> {
    private static final DateExpression<Date> CURRENT_DATE = DateExpression.currentDate(Date.class);
    private static final long serialVersionUID = 6054664454254721302L;
    @Nullable
    private volatile NumberExpression<Integer> dayOfMonth;
    @Nullable
    private volatile NumberExpression<Integer> dayOfWeek;
    @Nullable
    private volatile NumberExpression<Integer> dayOfYear;
    @Nullable
    private volatile DateExpression min;
    @Nullable
    private volatile DateExpression max;
    @Nullable
    private volatile NumberExpression<Integer> week;
    @Nullable
    private volatile NumberExpression<Integer> month;
    @Nullable
    private volatile NumberExpression<Integer> year;
    @Nullable
    private volatile NumberExpression<Integer> yearMonth;
    @Nullable
    private volatile NumberExpression<Integer> yearWeek;

    public static DateExpression<Date> currentDate() {
        return CURRENT_DATE;
    }

    public static <T extends Comparable> DateExpression<T> currentDate(Class<T> cl) {
        return DateOperation.create(cl, Ops.DateTimeOps.CURRENT_DATE, new Expression[0]);
    }

    public DateExpression(Expression<T> mixin) {
        super(mixin);
    }

    @Override
    public DateExpression<T> as(Path<T> alias) {
        return DateOperation.create(this.getType(), Ops.ALIAS, this.mixin, alias);
    }

    @Override
    public DateExpression<T> as(String alias) {
        return this.as((Path)new PathImpl(this.getType(), alias));
    }

    public NumberExpression<Integer> dayOfMonth() {
        if (this.dayOfMonth == null) {
            this.dayOfMonth = NumberOperation.create(Integer.class, Ops.DateTimeOps.DAY_OF_MONTH, this.mixin);
        }
        return this.dayOfMonth;
    }

    public NumberExpression<Integer> dayOfWeek() {
        if (this.dayOfWeek == null) {
            this.dayOfWeek = NumberOperation.create(Integer.class, Ops.DateTimeOps.DAY_OF_WEEK, this.mixin);
        }
        return this.dayOfWeek;
    }

    public NumberExpression<Integer> dayOfYear() {
        if (this.dayOfYear == null) {
            this.dayOfYear = NumberOperation.create(Integer.class, Ops.DateTimeOps.DAY_OF_YEAR, this.mixin);
        }
        return this.dayOfYear;
    }

    public DateExpression<T> max() {
        if (this.max == null) {
            this.max = DateOperation.create(this.getType(), Ops.AggOps.MAX_AGG, this.mixin);
        }
        return this.max;
    }

    public DateExpression<T> min() {
        if (this.min == null) {
            this.min = DateOperation.create(this.getType(), Ops.AggOps.MIN_AGG, this.mixin);
        }
        return this.min;
    }

    public NumberExpression<Integer> month() {
        if (this.month == null) {
            this.month = NumberOperation.create(Integer.class, Ops.DateTimeOps.MONTH, this.mixin);
        }
        return this.month;
    }

    public NumberExpression<Integer> week() {
        if (this.week == null) {
            this.week = NumberOperation.create(Integer.class, Ops.DateTimeOps.WEEK, this.mixin);
        }
        return this.week;
    }

    public NumberExpression<Integer> year() {
        if (this.year == null) {
            this.year = NumberOperation.create(Integer.class, Ops.DateTimeOps.YEAR, this.mixin);
        }
        return this.year;
    }

    public NumberExpression<Integer> yearMonth() {
        if (this.yearMonth == null) {
            this.yearMonth = NumberOperation.create(Integer.class, Ops.DateTimeOps.YEAR_MONTH, this.mixin);
        }
        return this.yearMonth;
    }

    public NumberExpression<Integer> yearWeek() {
        if (this.yearWeek == null) {
            this.yearWeek = NumberOperation.create(Integer.class, Ops.DateTimeOps.YEAR_WEEK, this.mixin);
        }
        return this.yearWeek;
    }
}

