/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.activeobjects;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsAccessor;
import com.radiantminds.roadmap.common.data.persistence.ao.common.AOIdentifiable;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.doorstop.AODoorStop;
import java.util.concurrent.Callable;
import net.java.ao.DBParam;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;

public class ActiveObjectsAccessorImpl
implements ActiveObjectsAccessor {
    private static final Log LOGGER = Log.with(ActiveObjectsAccessorImpl.class);
    private final ActiveObjects ao;
    private EntityManager entityManager;

    public ActiveObjectsAccessorImpl(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public <AOEntityType extends AOIdentifiable> AOEntityType get(Class<AOEntityType> aoClazz, int i) {
        return (AOEntityType)((AOIdentifiable)this.ao.get(aoClazz, (Object)i));
    }

    @Override
    public <AOEntityType extends AOIdentifiable> AOEntityType create(Class<AOEntityType> aoClazz) {
        return (AOEntityType)((AOIdentifiable)this.ao.create(aoClazz, new DBParam[0]));
    }

    @Override
    public <AOEntityType extends AOIdentifiable> AOEntityType create(Class<AOEntityType> aoClazz, int identifier) {
        return (AOEntityType)((AOIdentifiable)this.ao.create(aoClazz, new DBParam[]{new DBParam("ID_OTHER", (Object)identifier)}));
    }

    @Override
    public <AOEntityType extends AOIdentifiable> AOEntityType[] find(Class<AOEntityType> aoClazz) {
        try {
            return (AOIdentifiable[])this.ao.find(aoClazz);
        }
        catch (RuntimeException ex) {
            System.out.println("AO-ACCESSOR-ON-FIND-EXCEPTION for class " + aoClazz.getName());
            throw ex;
        }
    }

    @Override
    public <AOEntityType extends AOIdentifiable> AOEntityType[] find(Class<AOEntityType> aoClazz, String whereClause, Object ... parameters) {
        return (AOIdentifiable[])this.ao.find(aoClazz, whereClause, parameters);
    }

    @Override
    public <AOEntityType extends AOIdentifiable> boolean delete(Class<AOEntityType> aoClazz, AOEntityType entity) {
        if (entity != null) {
            this.ao.delete(new RawEntity[]{entity});
            return true;
        }
        return false;
    }

    @Override
    public <T> T executeInTransaction(final Callable<T> callable) throws Exception {
        Object retVal = this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                try {
                    return callable.call();
                }
                catch (Exception ex) {
                    return ex;
                }
            }
        });
        if (retVal instanceof Exception) {
            throw (Exception)retVal;
        }
        return (T)retVal;
    }

    @Override
    public void flush() {
        this.ao.flushAll();
    }

    @Override
    public EntityManager getEntityManager() {
        try {
            if (this.entityManager == null) {
                LOGGER.info("No entity manager available, getting AODoorStop...", new Object[0]);
                AODoorStop doorStop = (AODoorStop)this.ao.get(AODoorStop.class, (Object)1);
                LOGGER.info("Got AODoorStop: " + doorStop, new Object[0]);
                if (doorStop == null) {
                    LOGGER.info("DoorStop was null, creating", new Object[0]);
                    doorStop = (AODoorStop)this.ao.create(AODoorStop.class, new DBParam[0]);
                    doorStop.save();
                    LOGGER.info("Created door stop: Entity manager is : " + doorStop.getEntityManager(), new Object[0]);
                }
                this.entityManager = doorStop.getEntityManager();
            }
            return this.entityManager;
        }
        catch (Exception ex) {
            LOGGER.error("Entity Manager not accessible via AODoorStop.", new Object[0]);
            LOGGER.exception(ex, Log.LogLevel.ERROR);
            throw new RuntimeException("Entity Manager not accessible via AODoorStop.", ex);
        }
    }
}

