/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.scheduling.entities.transferables;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.people.ISprint;
import com.radiantminds.roadmap.common.data.entities.people.IterationStartType;
import com.radiantminds.roadmap.common.data.entities.people.PlanningMode;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingResource;
import com.radiantminds.roadmap.common.data.entities.people.SchedulingTeam;
import com.radiantminds.roadmap.common.scheduling.entities.transferables.TransferableResource;
import java.util.List;

public class TransferableTeam
implements SchedulingTeam {
    private PlanningMode planningMode;
    private IterationStartType iterationStartType;
    private Integer weeksPerSprint;
    private Double velocity;
    private Double incrementalAdjustment;
    private Boolean autoAdjustToAbsences;
    private List<TransferableResource> resources;
    private List<ISprint> sprints;
    private String id;
    private Long sortOrder;

    TransferableTeam(SchedulingTeam team) {
        this.id = team.getId();
        this.sortOrder = team.getSortOrder();
        this.planningMode = team.getPlanningMode();
        this.iterationStartType = team.getIterationStartType();
        this.weeksPerSprint = team.getWeeksPerSprint();
        this.velocity = team.getVelocity();
        this.incrementalAdjustment = team.getIncrementalAdjustment();
        this.autoAdjustToAbsences = team.getAutoAdjustToAbsences();
        this.resources = Lists.newArrayList();
        for (SchedulingResource schedulingResource : team.getResources()) {
            this.resources.add(new TransferableResource(schedulingResource));
        }
        this.sprints = team.getSprints();
    }

    @Override
    public PlanningMode getPlanningMode() {
        return this.planningMode;
    }

    @Override
    public IterationStartType getIterationStartType() {
        return this.iterationStartType;
    }

    @Override
    public Integer getWeeksPerSprint() {
        return this.weeksPerSprint;
    }

    @Override
    public Double getVelocity() {
        return this.velocity;
    }

    @Override
    public Double getIncrementalAdjustment() {
        return this.incrementalAdjustment;
    }

    @Override
    public Boolean getAutoAdjustToAbsences() {
        return this.autoAdjustToAbsences;
    }

    @Override
    public List<? extends SchedulingResource> getResources() {
        return this.resources;
    }

    @Override
    public List<ISprint> getSprints() {
        return this.sprints;
    }

    @Override
    public Long getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

