/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.SortableId;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
public class FixedSlotItemAssignmentProblem
implements SortableId {
    private final IWorkSlot workSlot;
    private final IProcessingItem item;

    public FixedSlotItemAssignmentProblem(IWorkSlot workSlot, IProcessingItem item) {
        this.workSlot = workSlot;
        this.item = item;
    }

    public IWorkSlot getWorkSlot() {
        return this.workSlot;
    }

    @Override
    public String getId() {
        return this.item.getId();
    }

    @Override
    public String getSortKey() {
        return this.item.getSortKey();
    }

    public IProcessingItem getItem() {
        return this.item;
    }

    public Map<IWorkResource, Float> getPositiveResourceAvailabilities() {
        Set<IWorkResource> resources = this.getItem().getAssignmentRestriction().getResources();
        HashMap availabilities = Maps.newHashMap();
        for (IWorkResource resource : resources) {
            float availability = resource.getRestrictedAvailability(this.workSlot.getIndex());
            if (!(availability > 0.0f)) continue;
            availabilities.put(resource, Float.valueOf(availability));
        }
        return availabilities;
    }

    public PositivePrimitivesMap<IResourceType> getDemands() {
        return this.item.getWorkDemand().getPositiveTypeAmounts();
    }

    public static Optional<FixedSlotItemAssignmentProblem> tryCreateForItem(IProcessingItem item) {
        Optional<Integer> slotIndex = item.getAssignmentRestriction().getWorkSlotIndex();
        if (!slotIndex.isPresent()) {
            return Optional.absent();
        }
        IWorkSlot slot = item.getAssignmentRestriction().getResourcePools().iterator().next().getResourceGroup().getWorkSlotWithIndex((Integer)slotIndex.get());
        return Optional.of((Object)new FixedSlotItemAssignmentProblem(slot, item));
    }

    public Set<IWorkResource> getAssignableResources() {
        return this.item.getAssignmentRestriction().getResources();
    }
}

