/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.calculation.CancellationState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.ApacheLpTransformer;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.ApacheSolutionCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.LpSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.math.lp.WeightedAssignmentLpProblem;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Optional;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.linear.SimplexSolver;

public class ApacheLpAssignmentSolver
implements LpAssignmentSolver {
    private static final Log LOGGER = Log.with(ApacheLpAssignmentSolver.class);
    private final SimplexSolver simplexSolver;
    private final ApacheLpTransformer lpTransformer;
    private final ApacheSolutionCreator solutionCreator;
    private final CancellationState cancellationState;

    public ApacheLpAssignmentSolver(CancellationState cancellationState) {
        this(new SimplexSolver(0.001), new ApacheLpTransformer(), new ApacheSolutionCreator(), cancellationState);
    }

    ApacheLpAssignmentSolver(SimplexSolver simplexSolver, ApacheLpTransformer lpTransformer, ApacheSolutionCreator solutionCreator, CancellationState cancellationState) {
        this.simplexSolver = simplexSolver;
        this.lpTransformer = lpTransformer;
        this.solutionCreator = solutionCreator;
        this.cancellationState = cancellationState;
    }

    @Override
    public Optional<LpSolution> trySolve(WeightedAssignmentLpProblem problem) throws InterruptedException {
        if (this.cancellationState.isCancelled()) {
            throw new InterruptedException();
        }
        LogUtil.debug(LOGGER, "try solve problem: %s", problem);
        OptimizationData[] optData = this.lpTransformer.transform(problem);
        try {
            PointValuePair optimize = this.simplexSolver.optimize(optData);
            LpSolution lpSolution = this.solutionCreator.create(optimize, problem);
            LogUtil.debug(LOGGER, "found solution: %s", lpSolution);
            return Optional.of((Object)lpSolution);
        }
        catch (Exception e) {
            LogUtil.debug(LOGGER, "caught exception - return null", e);
            return Optional.absent();
        }
    }
}

