/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.group;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.mysema.commons.lang.Pair;
import com.mysema.query.group.AbstractGroupExpression;
import com.mysema.query.group.GAvg;
import com.mysema.query.group.GList;
import com.mysema.query.group.GMap;
import com.mysema.query.group.GMax;
import com.mysema.query.group.GMin;
import com.mysema.query.group.GOne;
import com.mysema.query.group.GSet;
import com.mysema.query.group.GSum;
import com.mysema.query.group.GroupByBuilder;
import com.mysema.query.group.GroupExpression;
import com.mysema.query.group.MixinGroupExpression;
import com.mysema.query.group.QPair;
import com.mysema.query.types.Expression;
import com.mysema.query.types.QList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@BridgeMethodsAdded
public final class GroupBy {
    public static <K> GroupByBuilder<K> groupBy(Expression<K> key) {
        return new GroupByBuilder<K>(key);
    }

    public static GroupByBuilder<List<?>> groupBy(Expression<?> ... keys) {
        return new GroupByBuilder(new QList(keys));
    }

    public static <E extends Comparable<E>> AbstractGroupExpression<E, E> min(Expression<E> expression) {
        return new GMin<E>(expression);
    }

    public static <E extends Number> AbstractGroupExpression<E, E> sum(Expression<E> expression) {
        return new GSum<E>(expression);
    }

    public static <E extends Number> AbstractGroupExpression<E, E> avg(Expression<E> expression) {
        return new GAvg<E>(expression);
    }

    public static <E extends Comparable<E>> AbstractGroupExpression<E, E> max(Expression<E> expression) {
        return new GMax<E>(expression);
    }

    public static <E> AbstractGroupExpression<E, List<E>> list(Expression<E> expression) {
        return new GList<E>(expression);
    }

    public static <E, F> AbstractGroupExpression<E, List<F>> list(GroupExpression<E, F> groupExpression) {
        return new MixinGroupExpression(groupExpression, new GList(groupExpression));
    }

    public static <E> AbstractGroupExpression<E, Set<E>> set(Expression<E> expression) {
        return new GSet<E>(expression);
    }

    public static <E, F> GroupExpression<E, Set<F>> set(GroupExpression<E, F> groupExpression) {
        return new MixinGroupExpression(groupExpression, new GSet(groupExpression));
    }

    @WithBridgeMethods(value={Expression.class}, castRequired=true)
    public static <K, V> AbstractGroupExpression<Pair<K, V>, Map<K, V>> map(Expression<K> key, Expression<V> value) {
        return new GMap<K, V>(QPair.create(key, value));
    }

    public static <K, V, T> AbstractGroupExpression<Pair<K, V>, Map<T, V>> map(GroupExpression<K, T> key, Expression<V> value) {
        return GroupBy.map(key, new GOne<V>(value));
    }

    public static <K, V, U> AbstractGroupExpression<Pair<K, V>, Map<K, U>> map(Expression<K> key, GroupExpression<V, U> value) {
        return GroupBy.map(new GOne<K>(key), value);
    }

    public static <K, V, T, U> AbstractGroupExpression<Pair<K, V>, Map<T, U>> map(GroupExpression<K, T> key, GroupExpression<V, U> value) {
        return new GMap.Mixin(key, value, new GMap(QPair.create(key, value)));
    }

    private GroupBy() {
    }
}

