/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.rest.services.workitems;

import com.google.common.collect.Lists;
import com.radiantminds.roadmap.common.data.entities.workitems.IWorkItem;
import com.radiantminds.roadmap.common.data.persistence.common.entitypersistence.PortfolioWorkItemPersistence;
import com.radiantminds.roadmap.common.handlers.EntityContext;
import com.radiantminds.roadmap.common.handlers.annotations.AuthorizedPlanReadAccess;
import com.radiantminds.roadmap.common.rest.common.ResponseBuilder;
import com.radiantminds.roadmap.common.rest.entities.common.messaging.RestMessaging;
import java.util.List;
import javax.ws.rs.core.Response;

public interface WorkItemServiceHandler {
    @AuthorizedPlanReadAccess
    public Response entryGet(EntityContext<IWorkItem> var1, boolean var2) throws Exception;

    public static class Impl
    implements WorkItemServiceHandler {
        private final PortfolioWorkItemPersistence workItemPersistence;

        public Impl(PortfolioWorkItemPersistence workItemPersistence) {
            this.workItemPersistence = workItemPersistence;
        }

        @Override
        public Response entryGet(EntityContext<IWorkItem> entityContext, boolean includeReplanning) throws Exception {
            List<? extends IWorkItem> workItems = this.workItemPersistence.listPlainWorkItemsForPlanForIds(entityContext.getEntityInfo().getPlanId(), Lists.newArrayList((Object[])new String[]{entityContext.getEntityId()}), includeReplanning);
            IWorkItem item = Impl.getWorkItemByIdFromForestRecursive(workItems, entityContext.getEntityId());
            if (item == null) {
                return ResponseBuilder.badRequest(RestMessaging.entityNotFound());
            }
            return entityContext.ok(item);
        }

        private static IWorkItem getWorkItemByIdFromForestRecursive(List<? extends IWorkItem> workItems, String id) {
            if (workItems == null) {
                return null;
            }
            for (IWorkItem iWorkItem : workItems) {
                if (iWorkItem.getId().equals(id)) {
                    return iWorkItem;
                }
                IWorkItem fromChildren = Impl.getWorkItemByIdFromForestRecursive(iWorkItem.getChildren(), id);
                if (fromChildren == null) continue;
                return fromChildren;
            }
            return null;
        }
    }
}

