/*
 * Decompiled with CFR 0.152.
 */
package com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.sql;

import com.google.common.base.Optional;
import com.radiantminds.roadmap.common.data.activeobjects.ActiveObjectsUtilities;
import com.radiantminds.roadmap.common.data.common.DataMode;
import com.radiantminds.roadmap.common.data.entities.workitems.IEstimate;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.skills.AOSkill;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.estimate.AOEstimate;
import com.radiantminds.roadmap.common.data.persistence.ao.entities.workitems.workitem.AOWorkItem;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.AOQueryGenerator;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.BaseAOPersistenceSQL;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IQuery;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IUpdate;
import com.radiantminds.roadmap.common.data.persistence.ao.sql.statements.IVoidQuery;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class EstimateUpdateSQL
extends BaseAOPersistenceSQL {
    public EstimateUpdateSQL(ActiveObjectsUtilities utilities) {
        super(utilities);
    }

    private static boolean isEstimateNullsy(IEstimate estimate, boolean replanning) {
        return estimate.getEstimate() == null || !replanning && estimate.getEstimate() == 0.0;
    }

    public void setEstimate(final String workItemId, final String estimateType, final String fk, DataMode dataMode, final IEstimate estimate) throws Exception {
        final boolean replanning = dataMode == DataMode.Replanning;
        final boolean original = dataMode == DataMode.Original;
        this.sql(new IVoidQuery(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "estimate").select().col("estimate", "ID_OTHER", false).from("estimate").where().col("estimate", "aoworkitem").eq().numeric(workItemId).and().col("estimate", "targetType").eq().str(estimateType).and().col("estimate", "replanning").eq().bool(replanning).and().col("estimate", "original").eq().bool(original).and();
                if (fk != null) {
                    generator.col("estimate", "targetId").eq().numeric(fk);
                } else {
                    generator.col("estimate", "targetId").isNull();
                }
            }

            @Override
            public void handleResult(ResultSet set) throws Exception {
                if (set.next()) {
                    final String id = set.getString(1);
                    if (!EstimateUpdateSQL.isEstimateNullsy(estimate, replanning)) {
                        EstimateUpdateSQL.this.sql(new IUpdate(){

                            @Override
                            public void sql(AOQueryGenerator generator) throws Exception {
                                generator.withTable(AOEstimate.class, "estimate").update().tableNoAlias("estimate").set().colNoAlias("estimate", "estimate").eq().numeric(estimate.getEstimate()).where().colIdNoAlias("estimate").eq().numeric(id);
                            }
                        });
                    } else {
                        EstimateUpdateSQL.this.sql(new IUpdate(){

                            @Override
                            public void sql(AOQueryGenerator generator) throws Exception {
                                generator.withTable(AOEstimate.class, "estimate").deleteFrom().tableNoAlias("estimate").where().colIdNoAlias("estimate").eq().numeric(id);
                            }
                        });
                    }
                } else if (!EstimateUpdateSQL.isEstimateNullsy(estimate, replanning)) {
                    EstimateUpdateSQL.this.sql(new IUpdate(){

                        @Override
                        public void sql(AOQueryGenerator generator) throws Exception {
                            generator.withTable(AOEstimate.class, "estimate").insert().tableNoAlias("estimate").raw("(").colNoAlias("estimate", "aoworkitem").colNoAlias("estimate", "estimate").colNoAlias("estimate", "targetType").colNoAlias("estimate", "replanning").colNoAlias("estimate", "original");
                            if (fk != null) {
                                generator = generator.colNoAlias("estimate", "targetId");
                            }
                            generator = generator.raw(")").raw("VALUES").raw("(").numeric(workItemId).raw(", ").numeric(estimate.getEstimate()).raw(", ").str(estimateType).raw(", ").bool(replanning).raw(", ").bool(original);
                            if (fk != null) {
                                generator = generator.raw(",").numeric(fk);
                            }
                            generator.raw(")");
                        }
                    });
                    EstimateUpdateSQL.this.cascade(workItemId, estimateType, fk, replanning, original);
                } else {
                    EstimateUpdateSQL.this.cascade(workItemId, estimateType, fk, replanning, original);
                }
            }
        });
    }

    private void cascade(final String workItemId, String estimateType, final String fk, final boolean replanning, final boolean original) throws Exception {
        if ("total".equals(estimateType)) {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOEstimate.class, "t").deleteFrom().tableNoAlias("t").where().colNoAlias("t", "aoworkitem").eq().numeric(workItemId).and().colNoAlias("t", "replanning").eq().bool(replanning).and().colNoAlias("t", "original").eq().bool(original).and().colNoAlias("t", "targetType").neq().str("total");
                }
            });
        } else if ("stage".equals(estimateType)) {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOEstimate.class, "t").withTable(AOSkill.class, "skill").deleteFrom().tableNoAlias("t").where().colNoAlias("t", "aoworkitem").eq().numeric(workItemId).and().colNoAlias("t", "replanning").eq().bool(replanning).and().colNoAlias("t", "original").eq().bool(original).and().raw("(").raw("(").colNoAlias("t", "targetType").eq().str("total").raw(")").or().raw("(").colNoAlias("t", "targetType").eq().str("skill").and().colNoAlias("t", "targetId").raw("IN (").select().col("skill", "ID_OTHER", false).from("skill").where().col("skill", "aostage").eq().numeric(fk).raw(")").raw(")").raw(")");
                }
            });
        } else if ("skill".equals(estimateType)) {
            this.sql(new IUpdate(){

                @Override
                public void sql(AOQueryGenerator generator) throws Exception {
                    generator.withTable(AOEstimate.class, "t").withTable(AOSkill.class, "skill").deleteFrom().tableNoAlias("t").where().colNoAlias("t", "aoworkitem").eq().numeric(workItemId).and().colNoAlias("t", "replanning").eq().bool(replanning).and().colNoAlias("t", "original").eq().bool(original).and().raw("(").raw("(").colNoAlias("t", "targetType").eq().str("total").raw(")").or().raw("(").colNoAlias("t", "targetType").eq().str("stage").and().colNoAlias("t", "targetId").raw("IN (").select().col("skill", "aostage").from("skill").where().col("skill", "ID_OTHER", false).eq().numeric(fk).raw(")").raw(")").raw(")");
                }
            });
        }
    }

    public void clearEstimates(final String workItemId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").deleteFrom().tableNoAlias("e").where().colNoAlias("e", "aoworkitem").eq().numeric(workItemId);
            }
        });
    }

    public void clearEstimatesForTarget(final String targetType, final String targetId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").deleteFrom().tableNoAlias("e").where().colNoAlias("e", "targetType").eq().str(targetType).and().colNoAlias("e", "targetId").eq().numeric(targetId);
            }
        });
    }

    public void clearReplanningEstimates(final String workItemId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").deleteFrom().tableNoAlias("e").where().colNoAlias("e", "aoworkitem").eq().numeric(workItemId).and().colNoAlias("e", "replanning").eq().bool(true);
            }
        });
    }

    public void clearOriginalEstimates(final String workItemId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").deleteFrom().tableNoAlias("e").where().colNoAlias("e", "aoworkitem").eq().numeric(workItemId).and().colNoAlias("e", "original").eq().bool(true);
            }
        });
        this.setHasOriginalEstimates(workItemId, false);
    }

    public boolean hasOriginalEstimates(final String workItemId) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").select().col("w", "hasOriginalEstimates").from("w").where().colId("w").eq().numeric(workItemId);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getBoolean(result, 1);
                }
                return false;
            }
        });
    }

    private void setHasOriginalEstimates(final String workItemId, final boolean has) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOWorkItem.class, "w").update().tableNoAlias("w").set().colNoAlias("w", "hasOriginalEstimates").eq().bool(has).where().colIdNoAlias("w").eq().numeric(workItemId);
            }
        });
    }

    public void copyCurrentToOriginalEstimates(String workItemId, Optional<Double> defaultEstimate, boolean overwrite) throws SQLException {
        boolean performCopy = true;
        if (overwrite) {
            this.clearOriginalEstimates(workItemId);
        } else {
            performCopy = this.hasNoOriginalEstimates(workItemId);
        }
        if (performCopy) {
            if (this.hasCurrentEstimates(workItemId)) {
                this.copyCurrentToOriginalEstimates(workItemId);
            } else if (defaultEstimate.isPresent()) {
                this.copyDefaultToOriginalEstimates(workItemId, (Double)defaultEstimate.get());
            }
            this.setHasOriginalEstimates(workItemId, true);
        }
    }

    private boolean hasNoOriginalEstimates(final String workItemId) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").select().raw("COUNT(*)").from("e").where().col("e", "aoWorkItem").eq().numeric(workItemId).and().col("e", "original").eq().bool(true);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getInt(result, 1) == 0;
                }
                return true;
            }
        });
    }

    private boolean hasCurrentEstimates(final String workItemId) throws SQLException {
        return this.sql(new IQuery<Boolean>(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").select().raw("COUNT(*)").from("e").where().col("e", "aoWorkItem").eq().numeric(workItemId).and().col("e", "original").eq().bool(false).and().col("e", "replanning").eq().bool(false);
            }

            @Override
            public Boolean handleResult(ResultSet result) throws Exception {
                if (result.next()) {
                    return BaseAOPersistenceSQL.getInt(result, 1) > 0;
                }
                return false;
            }
        });
    }

    private void copyCurrentToOriginalEstimates(final String workItemId) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").insert().tableNoAlias("e").raw("(").colNoAlias("e", "aoWorkItem").colNoAlias("e", "currency").colNoAlias("e", "estimate").colNoAlias("e", "targetId").colNoAlias("e", "targetType").colNoAlias("e", "replanning").colNoAlias("e", "original").raw(")(").select().colNoAlias("e", "aoWorkItem").colNoAlias("e", "currency").colNoAlias("e", "estimate").colNoAlias("e", "targetId").colNoAlias("e", "targetType").raw(",").bool(false).raw(",").bool(true).from(new String[0]).tableNoAlias("e").where().colNoAlias("e", "aoWorkItem").eq().numeric(workItemId).and().colNoAlias("e", "replanning").eq().bool(false).raw(")");
            }
        });
    }

    private void copyDefaultToOriginalEstimates(final String workItemId, final Double defaultEstimate) throws SQLException {
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").insert().tableNoAlias("e").raw("(").colNoAlias("e", "aoWorkItem").colNoAlias("e", "currency").colNoAlias("e", "estimate").colNoAlias("e", "targetId").colNoAlias("e", "targetType").colNoAlias("e", "replanning").colNoAlias("e", "original").raw(") VALUES (").numeric(workItemId).raw(",").nullValue().raw(",").numeric(defaultEstimate).raw(",").nullValue().raw(",").str("total").raw(",").bool(false).raw(",").bool(true).raw(")");
            }
        });
    }

    public void clearReplanningEstimatesBulk(final List<String> workItemIds) throws SQLException {
        if (workItemIds.isEmpty()) {
            return;
        }
        this.sql(new IUpdate(){

            @Override
            public void sql(AOQueryGenerator generator) throws Exception {
                generator.withTable(AOEstimate.class, "e").deleteFrom().tableNoAlias("e").where().colNoAlias("e", "replanning").eq().bool(true).and().inNumeric(new AOQueryGenerator.InOperandCallback(){

                    @Override
                    public void generateOperand(AOQueryGenerator generator) {
                        generator.colNoAlias("e", "aoworkitem");
                    }
                }, workItemIds);
            }
        });
    }
}

