/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.querydsl.schema;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.pocketknife.internal.querydsl.schema.DatabaseSchemaCreation;
import com.atlassian.pocketknife.internal.querydsl.util.MemoizingResettingReference;
import com.atlassian.pocketknife.internal.querydsl.util.Unit;
import com.google.common.base.Function;
import org.joor.Reflect;
import org.joor.ReflectException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DatabaseSchemaCreationImpl
implements DatabaseSchemaCreation {
    private static final Logger log = LoggerFactory.getLogger(DatabaseSchemaCreationImpl.class);
    private static final String AO_SERVICE_NAME = "com.atlassian.activeobjects.external.ActiveObjects";
    private final MemoizingResettingReference<Unit, Unit> initialised;
    private final BundleContext bundleContext;

    @Autowired
    public DatabaseSchemaCreationImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.initialised = new MemoizingResettingReference<Unit, Unit>(this.primeImpl());
    }

    @Override
    public void prime() {
        this.initialised.get(Unit.VALUE);
    }

    private Function<Unit, Unit> primeImpl() {
        return new Function<Unit, Unit>(){

            public Unit apply(Unit input) {
                DatabaseSchemaCreationImpl.this.getService(DatabaseSchemaCreationImpl.AO_SERVICE_NAME).foreach((Effect)new Effect<Object>(){

                    public void apply(Object ao) {
                        DatabaseSchemaCreationImpl.this.invokeAo(ao);
                    }
                });
                return Unit.VALUE;
            }
        };
    }

    private Option<Object> getService(String serviceName) {
        Option sRef = Option.option((Object)this.bundleContext.getServiceReference(serviceName));
        if (sRef.isDefined()) {
            return Option.option((Object)this.bundleContext.getService((ServiceReference)sRef.get()));
        }
        return Option.none();
    }

    private void invokeAo(Object ao) {
        try {
            log.debug("ActiveObjects found - invoking via reflection....");
            Reflect.on(ao).call("flushAll");
        }
        catch (ReflectException e) {
            log.warn("ActiveObjects method flushAll is not available : " + e.toString());
        }
    }
}

