/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.sprints;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.agile.AgileNotAvailableException;
import com.atlassian.rm.common.bridges.agile.AgileServiceOutcomeException;
import com.atlassian.rm.common.bridges.agile.common.service.BundleServiceServiceResultHandler;
import com.atlassian.rm.common.bridges.agile.service.BundleServiceServiceOutcomeHandler;
import com.atlassian.rm.common.bridges.agile.service.ServiceOutcomeHandlerAction;
import com.atlassian.rm.common.bridges.agile.sprints.AgileSprintIssueServiceBridge;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.api.plugins.access.BundleServiceAccessorProvider;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.agile.sprints.AgileSprintIssueServiceBridgeImpl")
@SupportedVersions(all=true)
class AgileSprintIssueServiceBridgeImpl
implements AgileSprintIssueServiceBridge {
    private static final String SPRINT_ISSUE_SERVICE_NAME = "com.atlassian.greenhopper.service.sprint.SprintIssueService";
    private final BundleServiceServiceResultHandler bundleServiceServiceResultHandler;
    private final BundleServiceServiceOutcomeHandler sprintIssueServiceOutcomeHandler;

    @Autowired
    AgileSprintIssueServiceBridgeImpl(BundleServiceAccessorProvider bundleServiceAccessorProvider) {
        this.bundleServiceServiceResultHandler = new BundleServiceServiceResultHandler(bundleServiceAccessorProvider, SPRINT_ISSUE_SERVICE_NAME);
        this.sprintIssueServiceOutcomeHandler = new BundleServiceServiceOutcomeHandler(bundleServiceAccessorProvider, SPRINT_ISSUE_SERVICE_NAME);
    }

    @Override
    public void moveIssuesToSprint(final ApplicationUser applicationUser, long sprintId, final Set<Issue> issues) throws AgileServiceOutcomeException, AgileNotAvailableException {
        final Sprint sprint = Sprint.builder().id(Long.valueOf(sprintId)).build();
        this.bundleServiceServiceResultHandler.perform(new BundleServiceServiceResultHandler.Action<SprintIssueService, ServiceResult>(){

            @Override
            public ServiceResult getServiceResult(SprintIssueService sprintIssueService) {
                return sprintIssueService.moveIssuesToSprint(applicationUser, sprint, (Collection)issues);
            }
        });
    }

    @Override
    public void moveIssuesToBacklog(final ApplicationUser applicationUser, final Set<Issue> issues) throws AgileServiceOutcomeException, AgileNotAvailableException {
        this.bundleServiceServiceResultHandler.perform(new BundleServiceServiceResultHandler.Action<SprintIssueService, ServiceResult>(){

            @Override
            public ServiceResult getServiceResult(SprintIssueService sprintIssueService) {
                return sprintIssueService.moveIssuesToBacklog(applicationUser, (Collection)issues);
            }
        });
    }

    @Override
    public Collection<Long> getSprintsForIssue(final ApplicationUser applicationUser, final Issue issue) throws AgileServiceOutcomeException, AgileNotAvailableException {
        return this.sprintIssueServiceOutcomeHandler.forServiceAccessor(new ServiceOutcomeHandlerAction<SprintIssueService, ServiceOutcome, Collection<Sprint>, Collection<Long>>(){

            @Override
            public ServiceOutcome getServiceOutcome(SprintIssueService sprintIssueService) {
                return sprintIssueService.getSprintsForIssue(applicationUser, issue);
            }

            @Override
            public Collection<Long> getResult(Collection<Sprint> result) {
                return result.stream().map(Sprint::getId).collect(Collectors.toList());
            }
        });
    }
}

