/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.agile.sprints;

import com.atlassian.rm.common.bridges.agile.sprints.AgileSprint;
import com.google.common.base.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class DefaultAgileSprint
implements AgileSprint {
    private final long id;
    private final Optional<Long> agileBoardId;
    private final AgileSprint.State state;
    private final String name;
    private final Optional<Long> sequence;
    private final Optional<DateTime> startDate;
    private final Optional<DateTime> endDate;
    private final Optional<DateTime> completeDate;
    private final Optional<String> goal;

    private DefaultAgileSprint(long id, String name, Long agileBoardId, AgileSprint.State state, Long sequence, Optional<DateTime> startDate, Optional<DateTime> endDate, Optional<DateTime> completeDate, Optional<String> goal) {
        this.id = id;
        this.name = name;
        this.agileBoardId = Optional.fromNullable((Object)agileBoardId);
        this.state = state;
        this.sequence = Optional.fromNullable((Object)sequence);
        this.startDate = startDate;
        this.endDate = endDate;
        this.completeDate = completeDate;
        this.goal = goal;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<Long> getAgileBoardId() {
        return this.agileBoardId;
    }

    @Override
    public AgileSprint.State getState() {
        return this.state;
    }

    @Override
    public Optional<Long> getSequence() {
        return this.sequence;
    }

    @Override
    public Optional<DateTime> getStartDateTime() {
        return this.startDate;
    }

    @Override
    public Optional<DateTime> getEndDateTime() {
        return this.endDate;
    }

    @Override
    public Optional<DateTime> getCompleteDateTime() {
        return this.completeDate;
    }

    @Override
    public Optional<String> getGoal() {
        return this.goal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultAgileSprint that = (DefaultAgileSprint)o;
        return new EqualsBuilder().append(this.id, that.id).append(this.agileBoardId, that.agileBoardId).append((Object)this.state, (Object)that.state).append(this.name, that.name).append(this.sequence, that.sequence).append(this.startDate, that.startDate).append(this.endDate, that.endDate).append(this.completeDate, that.completeDate).append(this.goal, that.goal).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).append(this.agileBoardId).append((Object)this.state).append(this.name).append(this.sequence).append(this.startDate).append(this.endDate).append(this.completeDate).append(this.goal).toHashCode();
    }

    public static Builder builder(AgileSprint agileSprint) {
        return new Builder().id(agileSprint.getId()).name(agileSprint.getName()).agileBoardId((Long)agileSprint.getAgileBoardId().orNull()).state(agileSprint.getState()).sequence((Long)agileSprint.getSequence().orNull()).startDate(agileSprint.getStartDateTime()).endDate(agileSprint.getEndDateTime()).completeDate(agileSprint.getCompleteDateTime()).goal(agileSprint.getGoal());
    }

    public static class Builder {
        private long id;
        private String name;
        private Long agileBoardId;
        private AgileSprint.State state;
        private Long sequence;
        private Optional<DateTime> startDate = Optional.absent();
        private Optional<DateTime> endDate = Optional.absent();
        private Optional<DateTime> completeDate = Optional.absent();
        private Optional<String> goal = Optional.absent();

        public Builder id(long id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder agileBoardId(Long agileBoardId) {
            this.agileBoardId = agileBoardId;
            return this;
        }

        public Builder state(AgileSprint.State state) {
            this.state = state;
            return this;
        }

        public Builder sequence(Long sequence) {
            this.sequence = sequence;
            return this;
        }

        @Deprecated
        public Builder startDate(Long startDate) {
            this.startDate = this.toUtcDateTime(startDate);
            return this;
        }

        public Builder startDate(Optional<DateTime> startDate) {
            this.startDate = startDate;
            return this;
        }

        private Optional<DateTime> toUtcDateTime(Long startDate) {
            if (startDate == null) {
                return Optional.absent();
            }
            return Optional.of((Object)new DateTime((Object)startDate, DateTimeZone.UTC));
        }

        @Deprecated
        public Builder endDate(Long endDate) {
            this.endDate = this.toUtcDateTime(endDate);
            return this;
        }

        public Builder endDate(Optional<DateTime> endDate) {
            this.endDate = endDate;
            return this;
        }

        @Deprecated
        public Builder completeDate(Long completeDate) {
            this.completeDate = this.toUtcDateTime(completeDate);
            return this;
        }

        public Builder completeDate(Optional<DateTime> completeDate) {
            this.completeDate = completeDate;
            return this;
        }

        public Builder goal(Optional<String> goal) {
            this.goal = goal;
            return this;
        }

        public DefaultAgileSprint build() {
            return new DefaultAgileSprint(this.id, this.name, this.agileBoardId, this.state, this.sequence, this.startDate, this.endDate, this.completeDate, this.goal);
        }
    }
}

