/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.cache;

import com.atlassian.rm.common.bridges.jira.cache.LoadFunction;
import com.atlassian.rm.common.bridges.jira.cache.OperationScope;
import com.atlassian.rm.common.bridges.jira.cache.RequestCacheBridge;
import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;

class DefaultOperationScopeGuavaCache<T>
implements RequestCacheBridge<T> {
    private final Cache<String, T> cache;
    private final OperationScope scope;

    DefaultOperationScopeGuavaCache(OperationScope scope, int expireSecondsAfterAccess) {
        this.scope = scope;
        this.cache = CacheBuilder.newBuilder().expireAfterAccess((long)expireSecondsAfterAccess, TimeUnit.SECONDS).build();
    }

    DefaultOperationScopeGuavaCache(OperationScope scope) {
        this.scope = scope;
        this.cache = CacheBuilder.newBuilder().build();
    }

    @Override
    public void discard() {
        Optional<String> scopeId = this.scope.getId();
        if (scopeId.isPresent()) {
            this.cache.invalidate(scopeId.get());
        }
    }

    @Override
    public Optional<T> get() {
        Optional<String> scopeId = this.scope.getId();
        if (!scopeId.isPresent()) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)this.cache.getIfPresent(scopeId.get()));
    }

    @Override
    public T getOrLoad(LoadFunction<T> loader) throws Exception {
        Optional<T> cached = this.get();
        if (cached.isPresent()) {
            return (T)cached.get();
        }
        T loaded = loader.load();
        this.store(loaded);
        return loaded;
    }

    @Override
    public void store(T value) {
        Optional<String> scopeId = this.scope.getId();
        if (!scopeId.isPresent()) {
            return;
        }
        this.cache.put(scopeId.get(), value);
    }
}

