/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.fields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.vdi.NonNullCustomFieldProvider;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.index.FieldIndexer;
import com.atlassian.rm.common.bridges.jira.index.FieldValueRetriever;
import com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldHelperBridge;
import com.atlassian.rm.common.bridges.jira.issue.fields.NonNullCustomFieldProviderImpl;
import com.atlassian.rm.common.bridges.lucene.Document73;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.document.Document;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldHelperBridgeImpl")
@SupportedVersions(all=true)
public class CustomFieldHelperBridgeImpl
implements CustomFieldHelperBridge {
    private final Map<String, NonNullCustomFieldProvider> nonNullCustomFieldProviders = new ConcurrentHashMap<String, NonNullCustomFieldProvider>();

    @Override
    public List<IssueType> getAssociatedIssueTypes(CustomField customField) {
        return customField.getAssociatedIssueTypes();
    }

    @Override
    public CustomFieldSearcherInformation createSearcherInformation(CustomField field, FieldIndexer fieldIndexer) {
        return new CustomFieldSearcherInformation(field.getId(), field.getNameKey(), Collections.singletonList(new FieldIndexerDelegate(fieldIndexer)), new AtomicReference<CustomField>(field));
    }

    @Override
    public NonNullCustomFieldProvider getNonNullCustomFieldProvider(String customFieldTypeKey, FieldValueRetriever retriever) {
        return this.nonNullCustomFieldProviders.computeIfAbsent(customFieldTypeKey, key -> new NonNullCustomFieldProviderImpl(retriever));
    }

    private static class FieldIndexerDelegate
    implements com.atlassian.jira.issue.index.indexers.FieldIndexer {
        private final FieldIndexer fieldIndexer;

        FieldIndexerDelegate(FieldIndexer fieldIndexer) {
            this.fieldIndexer = fieldIndexer;
        }

        public String getId() {
            return this.fieldIndexer.getId();
        }

        public String getDocumentFieldId() {
            return this.fieldIndexer.getDocumentFieldId();
        }

        public void addIndex(Document doc, Issue issue) {
            this.fieldIndexer.addIndex(new Document73(doc), issue);
        }

        public boolean isFieldVisibleAndInScope(Issue issue) {
            return this.fieldIndexer.isFieldVisibleAndInScope(issue);
        }

        public Boolean skipsIndexingNull() {
            return this.fieldIndexer.skipsIndexingNull();
        }
    }
}

