/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.fields;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.customfield.CreateValidationResult;
import com.atlassian.jira.bc.customfield.CustomFieldDefinition;
import com.atlassian.jira.bc.customfield.CustomFieldService;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldServiceBridge;
import com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldServiceException;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.fields.CustomFieldServiceBridgeImpl")
@SupportedVersions(all=true)
public class CustomFieldServiceBridgeImpl
implements CustomFieldServiceBridge {
    private final CustomFieldService customFieldService;
    private final CustomFieldManager customFieldManager;
    private final FieldScreenManager fieldScreenManager;

    @Autowired
    CustomFieldServiceBridgeImpl(CustomFieldService customFieldService, CustomFieldManager customFieldManager, FieldScreenManager fieldScreenManager) {
        this.customFieldService = customFieldService;
        this.customFieldManager = customFieldManager;
        this.fieldScreenManager = fieldScreenManager;
    }

    @Override
    public CustomField create(ApplicationUser user, CustomFieldDefinition customFieldDefinition) throws CustomFieldServiceException {
        ServiceOutcome validationResult = this.customFieldService.validateCreate(user, customFieldDefinition);
        if (!validationResult.isValid()) {
            throw new CustomFieldServiceException("Invalid create validation result", validationResult.getErrorCollection());
        }
        ServiceOutcome serviceOutcome = this.customFieldService.create((CreateValidationResult)validationResult.get());
        if (!serviceOutcome.isValid()) {
            throw new CustomFieldServiceException("Invalid creation result", serviceOutcome.getErrorCollection());
        }
        return (CustomField)serviceOutcome.get();
    }

    @Override
    public void delete(CustomField customField) throws CustomFieldServiceException {
        try {
            this.customFieldManager.removeCustomField(customField);
        }
        catch (RemoveException e) {
            throw new CustomFieldServiceException((Exception)((Object)e));
        }
    }

    @Override
    public void addToAllScreens(ApplicationUser user, CustomField customField) throws CustomFieldServiceException {
        ArrayList tabIds = Lists.newArrayList();
        for (FieldScreen screen : this.fieldScreenManager.getFieldScreens()) {
            for (FieldScreenTab tab : screen.getTabs()) {
                tabIds.add(tab.getId());
            }
        }
        this.customFieldService.addToScreenTabs(user, customField.getIdAsLong(), (List)tabIds);
    }
}

