/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.issue.status.category;

import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.issue.status.category.StatusCategory;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.issue.status.category.DefaultIssueStatusCategory;
import com.atlassian.rm.common.bridges.jira.issue.status.category.IssueStatusCategory;
import com.atlassian.rm.common.bridges.jira.issue.status.category.IssueStatusCategoryServiceBridge;
import com.google.common.base.Function;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.issue.status.category.IssueStatusCategoryServiceBridgeImpl")
@SupportedVersions(all=true)
class IssueStatusCategoryServiceBridgeImpl
implements IssueStatusCategoryServiceBridge {
    private static final Function<StatusCategory, IssueStatusCategory> TO_BRIDGE = statusCategory -> new DefaultIssueStatusCategory(statusCategory.getId(), statusCategory.getKey(), statusCategory.getName(), statusCategory.getPrimaryAlias(), statusCategory.getColorName());
    private final StatusCategoryManager statusCategoryManager;

    @Autowired
    public IssueStatusCategoryServiceBridgeImpl(StatusCategoryManager statusCategoryManager) {
        this.statusCategoryManager = statusCategoryManager;
    }

    @Override
    public List<IssueStatusCategory> getAllIssueStatusCategories() {
        return this.statusCategoryManager.getStatusCategories().stream().map(arg_0 -> TO_BRIDGE.apply(arg_0)).collect(Collectors.toList());
    }
}

