/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.license;

import com.atlassian.jira.license.JiraLicenseManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.rm.common.bridges.api.SupportedVersions;
import com.atlassian.rm.common.bridges.jira.license.LicenseData;
import com.atlassian.rm.common.bridges.jira.license.LicenseErrorType;
import com.atlassian.rm.common.bridges.jira.license.ProductLicenseServiceBridge;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.license.ProductLicenseServiceBridgeImpl")
@SupportedVersions(all=true)
class ProductLicenseServiceBridgeImpl
implements ProductLicenseServiceBridge {
    private final JiraLicenseManager licenseManager;

    @Autowired
    ProductLicenseServiceBridgeImpl(JiraLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    @Override
    public LicenseData getLicenseData() {
        boolean hasDataCenterLicenses = false;
        for (LicenseDetails licenseDetails : this.licenseManager.getLicenses()) {
            if (!licenseDetails.isDataCenter()) continue;
            hasDataCenterLicenses = true;
            if (licenseDetails.isExpired()) continue;
            return LicenseData.createValid();
        }
        if (hasDataCenterLicenses) {
            return LicenseData.createInvalid("Licensed expired.", LicenseErrorType.Expired, "Your product license has expired.");
        }
        return LicenseData.createInvalid("Product is not licensed.", LicenseErrorType.Unlicensed, "Please purchase a license or get an evaluation license.");
    }
}

