/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lifecycle;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.lifecycle.JiraVersionAwareLifecycleTaskGuavaPredicate;
import com.atlassian.rm.common.bridges.jira.lifecycle.PluginStartUpTask;
import com.atlassian.rm.common.bridges.jira.lifecycle.PluginStartUpTaskServiceBridge;
import com.atlassian.rm.common.bridges.jira.lifecycle.PluginStartUpTaskServiceBridgeProxy;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lifecycle.StartUpTaskCollector")
public class StartUpTaskCollector {
    private static final Log LOGGER = Log.with(StartUpTaskCollector.class);
    private final PluginStartUpTaskServiceBridgeProxy bridgeProxy;
    private final JiraVersionAwareLifecycleTaskGuavaPredicate jiraVersionFilter;
    @Autowired(required=false)
    private List<PluginStartUpTask> tasks = Collections.emptyList();

    @Autowired
    public StartUpTaskCollector(PluginStartUpTaskServiceBridgeProxy bridgeProxy, JiraVersionAwareLifecycleTaskGuavaPredicate jiraVersionFilter) {
        this.bridgeProxy = bridgeProxy;
        this.jiraVersionFilter = jiraVersionFilter;
    }

    @PostConstruct
    public void init() {
        LOGGER.debug("setting %d tasks on bridge", this.tasks.size());
        ((PluginStartUpTaskServiceBridge)this.bridgeProxy.get()).setPluginStartUpTasks(Lists.newArrayList((Iterable)Iterables.filter(this.tasks, (Predicate)this.jiraVersionFilter)));
    }
}

