/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.lifecycle;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.common.bridges.jira.lifecycle.JiraUpgradeTask;
import com.atlassian.rm.common.bridges.jira.lifecycle.JiraVersionAwareLifecycleTaskGuavaPredicate;
import com.atlassian.rm.common.bridges.jira.lifecycle.UpgradeTaskServiceBridge;
import com.atlassian.rm.common.bridges.jira.lifecycle.UpgradeTaskServiceBridgeProxy;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.bridges.jira.lifecycle.UpgradeTaskCollector")
public class UpgradeTaskCollector {
    private static final Log LOGGER = Log.with(UpgradeTaskCollector.class);
    private final UpgradeTaskServiceBridgeProxy bridgeProxy;
    private final JiraVersionAwareLifecycleTaskGuavaPredicate jiraVersionFilter;
    @Autowired(required=false)
    private List<JiraUpgradeTask> tasks = Collections.emptyList();

    @Autowired
    public UpgradeTaskCollector(UpgradeTaskServiceBridgeProxy bridgeProxy, JiraVersionAwareLifecycleTaskGuavaPredicate jiraVersionFilter) {
        this.bridgeProxy = bridgeProxy;
        this.jiraVersionFilter = jiraVersionFilter;
    }

    @PostConstruct
    public void init() {
        LOGGER.debug("setting %d tasks on bridge", this.tasks.size());
        Collections.sort(this.tasks, new Comparator<JiraUpgradeTask>(){

            @Override
            public int compare(JiraUpgradeTask o1, JiraUpgradeTask o2) {
                return Ints.compare((int)o1.getVersion(), (int)o2.getVersion());
            }
        });
        ((UpgradeTaskServiceBridge)this.bridgeProxy.get()).setUpgradeTasks(Lists.newArrayList((Iterable)Iterables.filter(this.tasks, (Predicate)this.jiraVersionFilter)));
    }
}

