/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.jira.threading;

import com.atlassian.rm.common.bridges.jira.threading.LongRunningTaskData;
import com.atlassian.rm.common.bridges.jira.threading.LongRunningTaskState;
import com.google.common.base.Optional;
import java.util.concurrent.ExecutionException;

class LocalThreadPoolLongRunningTaskState
implements LongRunningTaskState {
    private final long progress;
    private final boolean done;
    private boolean error;
    private Optional<String> result;
    private Optional<Throwable> exception;

    LocalThreadPoolLongRunningTaskState(LongRunningTaskData data) {
        this.progress = data.getProgress().getProgressInPercent();
        boolean bl = this.done = data.getFuture().isDone() || data.getFuture().isCancelled();
        if (this.done) {
            try {
                this.result = Optional.fromNullable((Object)data.getFuture().get());
                this.error = false;
                this.exception = Optional.absent();
            }
            catch (ExecutionException ee) {
                this.error = true;
                this.result = Optional.absent();
                this.exception = Optional.of((Object)ee.getCause());
            }
            catch (InterruptedException ie) {
                this.error = true;
                this.result = Optional.absent();
                this.exception = Optional.of((Object)ie);
            }
        } else {
            this.error = false;
            this.result = Optional.absent();
            this.exception = Optional.absent();
        }
    }

    @Override
    public long getProgressInPercent() {
        return this.progress;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean hasError() {
        return this.error;
    }

    @Override
    public Optional<String> getResult() {
        return this.result;
    }

    @Override
    public Optional<Throwable> getException() {
        return this.exception;
    }
}

