/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.Document;
import com.atlassian.rm.common.bridges.lucene.Field;
import com.atlassian.rm.common.bridges.lucene.Field73;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public class Document73
implements Document {
    private final org.apache.lucene.document.Document document;

    public Document73(org.apache.lucene.document.Document document) {
        this.document = document;
    }

    org.apache.lucene.document.Document getLuceneValue() {
        return this.document;
    }

    @Override
    public void add(Field field) {
        IndexableField indexableField = ((Field73)field).getLuceneValue();
        Field.Configuration configuration = ((Field73)field).getConfiguration();
        this.document.add(indexableField);
        if (indexableField instanceof LongPoint) {
            if (configuration.isStored()) {
                this.document.add((IndexableField)new StoredField(indexableField.name(), indexableField.numericValue().longValue()));
            }
            if (configuration.isSortable()) {
                if (configuration.isMultiValued()) {
                    this.document.add((IndexableField)new SortedNumericDocValuesField(indexableField.name(), indexableField.numericValue().longValue()));
                } else {
                    this.document.add((IndexableField)new NumericDocValuesField(indexableField.name(), indexableField.numericValue().longValue()));
                }
            }
        } else if (indexableField instanceof DoublePoint) {
            if (configuration.isStored()) {
                this.document.add((IndexableField)new StoredField(indexableField.name(), indexableField.numericValue().doubleValue()));
            }
            if (configuration.isSortable()) {
                if (configuration.isMultiValued()) {
                    this.document.add((IndexableField)new SortedNumericDocValuesField(indexableField.name(), NumericUtils.doubleToSortableLong((double)indexableField.numericValue().doubleValue())));
                } else {
                    this.document.add((IndexableField)new DoubleDocValuesField(indexableField.name(), indexableField.numericValue().doubleValue()));
                }
            }
        } else if (configuration.isSortable()) {
            if (configuration.isMultiValued()) {
                this.document.add((IndexableField)new SortedSetDocValuesField(indexableField.name(), new BytesRef((CharSequence)indexableField.stringValue())));
            } else {
                this.document.add((IndexableField)new SortedDocValuesField(indexableField.name(), new BytesRef((CharSequence)indexableField.stringValue())));
            }
        }
    }

    @Override
    public void removeField(String name) {
        this.document.removeField(name);
    }

    @Override
    public Field getField(String name) {
        IndexableField indexableField = this.document.getField(name);
        return new Field73(indexableField, this.toFieldConfiguration(indexableField.fieldType()));
    }

    @Override
    public List<Field> getFields() {
        return Lists.transform((List)this.document.getFields(), (Function)new Function<IndexableField, Field>(){

            public Field apply(IndexableField indexableField) {
                return new Field73(indexableField, Document73.this.toFieldConfiguration(indexableField.fieldType()));
            }
        });
    }

    private Field.Configuration toFieldConfiguration(IndexableFieldType fieldType) {
        return ((Field.Configuration.Builder)Field.Configuration.BUILDER.get()).setAnalyzed(fieldType.tokenized()).setStored(fieldType.stored()).setSortable(fieldType.docValuesType() != DocValuesType.NONE).setMultiValued(fieldType.docValuesType() == DocValuesType.SORTED_SET || fieldType.docValuesType() == DocValuesType.SORTED_NUMERIC).setOmitNorms(fieldType.omitNorms()).build();
    }

    @Override
    public String getValue(String name) {
        return this.document.get(name);
    }

    @Override
    public List<String> getValues(String name) {
        return Arrays.asList(this.document.getValues(name));
    }

    public static class Factory
    implements Document.Factory {
        @Override
        public Document create() {
            return new Document73(new org.apache.lucene.document.Document());
        }
    }
}

