/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.bridges.lucene;

import com.atlassian.rm.common.bridges.lucene.NumberValueConverter;
import com.atlassian.rm.common.bridges.lucene.NumberValueConverter73;
import com.atlassian.rm.common.bridges.lucene.Query;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.math.LongMath;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;

public class Query73
implements Query {
    private final org.apache.lucene.search.Query query;

    public Query73(org.apache.lucene.search.Query query) {
        this.query = query;
    }

    public org.apache.lucene.search.Query getLuceneValue() {
        return this.query;
    }

    private static Set<Term> extractTerms(org.apache.lucene.search.Query query) {
        HashSet terms = Sets.newHashSet();
        if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            for (BooleanClause clause : booleanQuery.clauses()) {
                terms.addAll(Query73.extractTerms(clause.getQuery()));
            }
        } else if (query instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query;
            terms.add(termQuery.getTerm());
        }
        return terms;
    }

    @Override
    public Set<String> getStringValuesForParameter(String name) {
        HashSet values = Sets.newHashSet();
        for (Term term : Query73.extractTerms(this.query)) {
            if (!term.field().equals(name)) continue;
            values.add(term.text());
        }
        return values;
    }

    @Override
    public List<Query> extractClauses() {
        if (this.query instanceof BooleanQuery) {
            List clauses = ((BooleanQuery)this.query).clauses();
            return Lists.transform((List)clauses, (Function)new Function<BooleanClause, Query>(){

                public Query apply(BooleanClause booleanClause) {
                    return new Query73(booleanClause.getQuery());
                }
            });
        }
        return Collections.singletonList(this);
    }

    @Override
    public void recursivelyExtractFieldNames(Set<String> names) {
        Query73.recursivelyExtractFieldNames(names, this.query);
    }

    private static void recursivelyExtractFieldNames(Set<String> names, org.apache.lucene.search.Query query) {
        if (query instanceof TermQuery) {
            names.add(((TermQuery)query).getTerm().field());
        } else if (query instanceof BooleanQuery) {
            for (BooleanClause clause : ((BooleanQuery)query).clauses()) {
                Query73.recursivelyExtractFieldNames(names, clause.getQuery());
            }
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof Query73 && this.query.equals((Object)((Query73)obj).query);
    }

    public int hashCode() {
        return this.query.hashCode();
    }

    public String toString() {
        return this.query.toString();
    }

    public static class Builder
    implements Query.Builder {
        private final BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
        private int numClauses = 0;

        @Override
        public int numClauses() {
            return this.numClauses;
        }

        @Override
        public Query.Builder addOptionalSubQuery(Query query) {
            this.booleanQueryBuilder.add(((Query73)query).getLuceneValue(), BooleanClause.Occur.SHOULD);
            ++this.numClauses;
            return this;
        }

        @Override
        public Query.Builder addMandatorySubQuery(Query query) {
            this.booleanQueryBuilder.add(((Query73)query).getLuceneValue(), BooleanClause.Occur.MUST);
            ++this.numClauses;
            return this;
        }

        @Override
        public Query.Builder addExcludedQuery(Query query) {
            this.booleanQueryBuilder.add(((Query73)query).getLuceneValue(), BooleanClause.Occur.MUST_NOT);
            ++this.numClauses;
            return this;
        }

        @Override
        public Query build() {
            return new Query73((org.apache.lucene.search.Query)this.booleanQueryBuilder.build());
        }
    }

    public static class Factory
    implements Query.Factory {
        @Override
        public Query createMatchAllQuery() {
            return new Query73((org.apache.lucene.search.Query)new MatchAllDocsQuery());
        }

        @Override
        public Query createMatchNothingQuery() {
            return new Query73((org.apache.lucene.search.Query)new MatchNoDocsQuery());
        }

        @Override
        public Query createWildcardQuery(String name, String value) {
            return new Query73((org.apache.lucene.search.Query)new WildcardQuery(new Term(name, value)));
        }

        @Override
        public Query createTermQuery(String name, String value) {
            return new Query73((org.apache.lucene.search.Query)new TermQuery(new Term(name, value)));
        }

        @Override
        public <T> Query createDisjunctTermQuery(String termKey, Collection<T> possibleValues) {
            BooleanQuery.Builder booleanQueryBuilder = new BooleanQuery.Builder();
            for (T value : possibleValues) {
                booleanQueryBuilder.add((org.apache.lucene.search.Query)new TermQuery(new Term(termKey, value.toString())), BooleanClause.Occur.SHOULD);
            }
            return new Query73((org.apache.lucene.search.Query)booleanQueryBuilder.build());
        }

        @Override
        public Query createTermRangeQuery(String name, @Nullable Number lower, @Nullable Number upper, boolean includeLower, boolean includeUpper) {
            NumberValueConverter converter = new NumberValueConverter73.Factory().create();
            return new Query73((org.apache.lucene.search.Query)TermRangeQuery.newStringRange((String)name, (String)converter.getStringForLucene(lower), (String)converter.getStringForLucene(upper), (boolean)includeLower, (boolean)includeUpper));
        }

        private static long longValueOf(Number number, long valueIfNull) {
            return number == null ? valueIfNull : number.longValue();
        }

        @Override
        public Query createNumericRangeQuery(String name, @Nullable Number lower, @Nullable Number upper, boolean includeLower, boolean includeUpper) {
            if (lower instanceof Long || upper instanceof Long) {
                long lowerLimit = Factory.longValueOf(lower, Long.MIN_VALUE);
                long upperLimit = Factory.longValueOf(upper, Long.MAX_VALUE);
                return new Query73(LongPoint.newRangeQuery((String)name, (long)(includeLower ? lowerLimit : LongMath.checkedAdd((long)lowerLimit, (long)1L)), (long)(includeUpper ? upperLimit : LongMath.checkedAdd((long)upperLimit, (long)-1L))));
            }
            throw new UnsupportedOperationException(String.format("Range query for lower=%s and upper=%s is not currently supported!", lower, upper));
        }

        @Override
        public Query createPhraseQuery() {
            return new Query73((org.apache.lucene.search.Query)new PhraseQuery.Builder().build());
        }

        @Override
        public Builder createQueryBuilder() {
            return new Builder();
        }
    }
}

