/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.common.pkqdsl.legacy;

import com.atlassian.rm.common.pkqdsl.legacy.Connections;
import com.atlassian.rm.common.pkqdsl.legacy.DatabaseCompatibilityKit;
import com.atlassian.rm.common.pkqdsl.legacy.DialectProvider;
import com.querydsl.sql.dml.SQLInsertClause;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.atlassian.rm.common.pkqdsl.legacy.DatabaseCompatibilityKitImpl")
public class DatabaseCompatibilityKitImpl
implements DatabaseCompatibilityKit {
    private final DialectProvider dialectProvider;

    @Autowired
    public DatabaseCompatibilityKitImpl(DialectProvider dialectProvider) {
        this.dialectProvider = dialectProvider;
    }

    @Override
    public <T> T executeWithKey(Connection connection, SQLInsertClause insertClause, Class<T> idClass) {
        if (this.isHSQLBefore20(connection)) {
            long howMany = insertClause.execute();
            if (howMany > 0L) {
                return DatabaseCompatibilityKitImpl.callHsqlIdentity(connection);
            }
            return null;
        }
        return (T)insertClause.executeWithKey(idClass);
    }

    private boolean isHSQLBefore20(Connection connection) {
        DialectProvider.DatabaseInfo databaseInfo = this.dialectProvider.getDialectConfig(connection).getDatabaseInfo();
        return databaseInfo.getSupportedDatabase() == DialectProvider.SupportedDatabase.HSQLDB && databaseInfo.getDatabaseMajorVersion() < 2;
    }

    private static <T> T callHsqlIdentity(Connection connection) {
        T idValue2;
        ResultSet resultSet;
        PreparedStatement prepareStatement;
        block5: {
            Object idValue2;
            prepareStatement = null;
            resultSet = null;
            prepareStatement = connection.prepareStatement("CALL IDENTITY()");
            resultSet = prepareStatement.executeQuery();
            if (!resultSet.next()) break block5;
            Object object = idValue2 = resultSet.getObject(1);
            Connections.close(resultSet);
            Connections.close(prepareStatement);
            return (T)object;
        }
        try {
            idValue2 = null;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Connections.close(resultSet);
                Connections.close(prepareStatement);
                throw throwable;
            }
        }
        Connections.close(resultSet);
        Connections.close(prepareStatement);
        return idValue2;
    }
}

