/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.instrumentation;

import com.google.common.collect.Lists;
import java.util.List;

public class SolverMetrics {
    public static final long NANOS_PER_MILLI = 1000000L;
    private List<Long> timeToScheduleIssues = Lists.newArrayList();
    private long cumulativeTimeToScheduleIssues = 0L;
    private long maxTimeToScheduleSingleIssue = 0L;

    public void addTimeToScheduleIssue(long millis) {
        this.timeToScheduleIssues.add(millis);
        this.cumulativeTimeToScheduleIssues += millis;
        this.maxTimeToScheduleSingleIssue = Math.max(millis, this.maxTimeToScheduleSingleIssue);
    }

    public long getTotalTimeToScheduleIssues() {
        return this.cumulativeTimeToScheduleIssues;
    }

    public double getTimeToScheduleIssuesMean() {
        return SolverMetrics.average(this.cumulativeTimeToScheduleIssues, this.timeToScheduleIssues.size());
    }

    public double getTimeToScheduleIssuesStandardDeviation() {
        return SolverMetrics.standardDeviation(this.timeToScheduleIssues, this.getTimeToScheduleIssuesMean());
    }

    public long getMaxTimeToScheduleSingleIssue() {
        return this.maxTimeToScheduleSingleIssue;
    }

    private static double average(long numerator, long denominator) {
        return denominator == 0L ? -1.0 : (double)numerator * 1.0 / (double)denominator;
    }

    private static double standardDeviation(List<Long> values, double mean) {
        if (values.isEmpty()) {
            return -1.0;
        }
        double sum = 0.0;
        for (long value : values) {
            double diff = (double)value - mean;
            sum += diff * diff;
        }
        return Math.sqrt(sum / (double)values.size());
    }
}

