/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.analysis;

import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IBoundedDiscreteStepFunction;
import com.google.common.base.Optional;
import java.util.Arrays;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

class BoundDiscreteStepFunction
implements IBoundedDiscreteStepFunction {
    private final float[] array;

    BoundDiscreteStepFunction(int timeBoundInclusive) {
        this.array = new float[timeBoundInclusive + 1];
    }

    BoundDiscreteStepFunction(float value, int timeBoundInclusive) {
        this.array = new float[timeBoundInclusive + 1];
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = value;
        }
    }

    @Override
    public Optional<Float> getAt(int x) {
        if (x > this.getBound()) {
            return Optional.absent();
        }
        return Optional.of((Object)Float.valueOf(this.array[x]));
    }

    @Override
    public boolean addBetween(int start, int end, float value) {
        int i = start;
        while (i <= Math.min(end, this.array.length - 1)) {
            int n = i++;
            this.array[n] = this.array[n] + value;
        }
        return end <= this.array.length - 1;
    }

    @Override
    public void multiply(float factor) {
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = this.array[i] * factor;
        }
    }

    public final int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public final boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, obj, new String[0]);
    }

    public String toString() {
        return "BoundedDiscreteStepFunction [" + Arrays.toString(this.array) + "]";
    }

    @Override
    public boolean setAt(int x, float value) {
        if (x > this.getBound()) {
            return false;
        }
        this.array[x] = value;
        return true;
    }

    @Override
    public int getBound() {
        return this.array.length - 1;
    }

    static IBoundedDiscreteStepFunction merge(IBoundedDiscreteStepFunction function1, IBoundedDiscreteStepFunction function2) {
        int newBound = Math.max(function1.getBound(), function2.getBound());
        BoundDiscreteStepFunction newFunction = new BoundDiscreteStepFunction(newBound);
        for (int i = 0; i <= newBound; ++i) {
            float value1 = 0.0f;
            if (i <= function1.getBound()) {
                value1 = ((Float)function1.getAt(i).get()).floatValue();
            }
            float value2 = 0.0f;
            if (i <= function2.getBound()) {
                value2 = ((Float)function2.getAt(i).get()).floatValue();
            }
            newFunction.setAt(i, value1 + value2);
        }
        return newFunction;
    }
}

