/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.analysis;

import com.atlassian.rm.jpo.scheduling.roadmap.analysis.ISlotBottleneckResult;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.MutablePositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.atlassian.rm.jpo.scheduling.util.collection.RmCollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;

@Immutable
class SlotBottleneckResult
implements ISlotBottleneckResult {
    private final Map<IWorkSlot, PositivePrimitivesMap<IResourceType>> slotToBottleneckValues;

    SlotBottleneckResult(Map<IWorkSlot, PositivePrimitivesMap<IResourceType>> slotToBottleneckValues) {
        this.slotToBottleneckValues = Collections.unmodifiableMap(slotToBottleneckValues);
    }

    @Override
    public Map<IWorkSlot, PositivePrimitivesMap<IResourceType>> getSlotToBottleneckValues() {
        return this.slotToBottleneckValues;
    }

    @Override
    public List<IResourceType> getBottlenecksIn(Iterable<IWorkSlot> slots) {
        MutablePositivePrimitivesMap<IResourceType> sum = RmCollectionUtils.newMutablePositiveMap();
        for (IWorkSlot slot : slots) {
            PositivePrimitivesMap<IResourceType> amounts = this.slotToBottleneckValues.get(slot);
            if (amounts == null) continue;
            sum.add(amounts);
        }
        List<IResourceType> descBottlenecks = RmUtils.getReverseOrderWithNumericalValues(sum);
        return descBottlenecks;
    }
}

