/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.analysis;

import com.atlassian.rm.jpo.scheduling.roadmap.analysis.BoundDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IBoundedDiscreteStepFunction;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.IUnstructuredStageProfile;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.StageProfileCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.analysis.StepFunctionCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingDefinition;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.processing.IProcessingStage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IUnstructuredItemSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IAggregatedWorkPackage;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@Immutable
class UnstructuredItemWaitingFunctionCalculator {
    private final StepFunctionCreator stepFunctionCreator = new StepFunctionCreator();
    private final StageProfileCreator stageProfileCreator = new StageProfileCreator();

    UnstructuredItemWaitingFunctionCalculator() {
    }

    Map<IResourceType, IBoundedDiscreteStepFunction> getWaitingFunctions(IUnstructuredItemSchedule schedule, IProcessingDefinition processingDefinition) {
        HashMap waitingFunctions = Maps.newHashMap();
        LinkedHashMap<IProcessingStage, IUnstructuredStageProfile> stageProfiles = this.stageProfileCreator.calculateStageProfiles(schedule, processingDefinition);
        Map<IResourceType, IBoundedDiscreteStepFunction> typeDoneFunctions = this.calculateTypeDoneFunctions(schedule);
        int end = schedule.getEnd();
        IAggregatedWorkPackage workPackage = schedule.getAggregatedWorkPackage();
        Set<IResourceType> types = workPackage.getResourceTypes();
        PositivePrimitivesMap<IResourceType> typeAmounts = workPackage.getPositiveTypeAmounts();
        for (IResourceType type : types) {
            float typeNeeded = typeAmounts.get(type);
            IBoundedDiscreteStepFunction doneAndProgress = typeDoneFunctions.get(type);
            IUnstructuredStageProfile stageProfile = UnstructuredItemWaitingFunctionCalculator.getStageProfileForType(type, stageProfiles);
            BoundDiscreteStepFunction waitingFunction = new BoundDiscreteStepFunction(end);
            for (int i = 0; i <= end; ++i) {
                float stageEligible = ((Float)stageProfile.getEligibleStageAmount(i).get()).floatValue();
                float typeDone = ((Float)doneAndProgress.getAt(i).get()).floatValue();
                float typeWaiting = Math.min(typeNeeded - typeDone, stageEligible);
                waitingFunction.setAt(i, typeWaiting);
            }
            waitingFunctions.put(type, waitingFunction);
        }
        return waitingFunctions;
    }

    private static IUnstructuredStageProfile getStageProfileForType(IResourceType type, LinkedHashMap<IProcessingStage, IUnstructuredStageProfile> stageProfiles) {
        for (Map.Entry<IProcessingStage, IUnstructuredStageProfile> stageEntry : stageProfiles.entrySet()) {
            if (!stageEntry.getKey().getResourceTypes().contains(type)) continue;
            return stageEntry.getValue();
        }
        return null;
    }

    private Map<IResourceType, IBoundedDiscreteStepFunction> calculateTypeDoneFunctions(IUnstructuredItemSchedule schedule) {
        HashMap doneAndProgressFunctions = Maps.newHashMap();
        for (IResourceType type : schedule.getAggregatedWorkPackage().getPositiveTypeAmounts().keySet()) {
            IBoundedDiscreteStepFunction doneAndProgress = this.stepFunctionCreator.addAmountsOnStart(Sets.newHashSet((Object[])new IResourceType[]{type}), schedule.getWorkAssignments(), schedule.getEnd());
            doneAndProgressFunctions.put(type, doneAndProgress);
        }
        return doneAndProgressFunctions;
    }
}

