/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.EpisodeState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.GreedyRoadmapScheduler;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.ITemporalDependencyState;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IBacklog;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.util.RmIdentifiableUtils;
import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class PossibleEpisodeTracker {
    private static final Log LOGGER = Log.with(GreedyRoadmapScheduler.class);
    private final Map<String, List<IEpisode>> itemIdToOpenEpisodes;
    private final Set<String> openStrictPhaseIds;

    PossibleEpisodeTracker(Map<String, List<IEpisode>> itemIdToOpenEpisodes, Set<String> openStrictPhaseIds) {
        this.itemIdToOpenEpisodes = itemIdToOpenEpisodes;
        this.openStrictPhaseIds = openStrictPhaseIds;
    }

    void setFailed(String itemId, String episodeId) {
        if (this.itemIdToOpenEpisodes.containsKey(itemId)) {
            List<IEpisode> episodes = this.itemIdToOpenEpisodes.get(itemId);
            if (!episodes.isEmpty() && episodes.get(0).getId().equals(episodeId)) {
                episodes.remove(0);
            } else {
                LOGGER.warn("illegal method call for item %s and episode %s", itemId, episodeId);
            }
        }
    }

    List<IEpisode> getPossibleEpisodesForItem(String itemId) {
        return this.itemIdToOpenEpisodes.get(itemId);
    }

    IEpisode getNextPossibleEpisode(String itemId) {
        return this.getPossibleEpisodesForItem(itemId).get(0);
    }

    boolean isToBeDone(String itemId) {
        return this.openStrictPhaseIds.isEmpty() || this.openStrictPhaseIds.contains(itemId);
    }

    void setDone(String itemId) {
        this.openStrictPhaseIds.remove(itemId);
    }

    void setDone(Collection<String> dependeeIds) {
        this.openStrictPhaseIds.removeAll(dependeeIds);
    }

    static PossibleEpisodeTracker createInstance(IRoadmapProblem problem, ITemporalDependencyState temporalState) {
        Map<String, List<IEpisode>> possibleEpisodes = PossibleEpisodeTracker.getPossibleEpisodes(problem, temporalState);
        return new PossibleEpisodeTracker(possibleEpisodes, PossibleEpisodeTracker.getIdsForStrictPhase(possibleEpisodes, problem.getBacklog()));
    }

    private static Map<String, List<IEpisode>> getPossibleEpisodes(IRoadmapProblem problem, ITemporalDependencyState temporalState) {
        HashMap itemToEpisodes = Maps.newHashMap();
        for (IProcessingItem item : problem.getBacklog().getProcessingItems()) {
            if (item.isStrictlyAssigned()) {
                itemToEpisodes.put(item.getId(), Lists.newArrayList(item.getPossibleEpisodes()));
                continue;
            }
            itemToEpisodes.put(item.getId(), PossibleEpisodeTracker.getPossibleEpisodes(problem, item, temporalState));
        }
        return itemToEpisodes;
    }

    private static List<IEpisode> getPossibleEpisodes(IRoadmapProblem problem, IProcessingItem item, ITemporalDependencyState temporalState) {
        List<IEpisode> possibleEpisodes = PossibleEpisodeTracker.getPossibleWithCausalRelations(problem, item);
        return PossibleEpisodeTracker.filterEmptyEpisodes(possibleEpisodes, temporalState);
    }

    private static List<IEpisode> getPossibleWithCausalRelations(IRoadmapProblem problem, IProcessingItem item) {
        List<IEpisode> episodes = problem.getTimePlan().getEpisodeStream(item.getStreamId()).getEpisodes();
        int minIndex = episodes.size();
        for (IProcessingItem dependee : problem.getBacklog().getDependencyDefinition().getTransitiveDependents(item)) {
            if (!dependee.isStrictlyAssigned() || !dependee.getStreamId().equals(item.getStreamId())) continue;
            minIndex = Math.min(minIndex, episodes.indexOf(dependee.getFixedEpisode().get()) + 1);
        }
        return episodes.subList(0, minIndex);
    }

    private static List<IEpisode> filterEmptyEpisodes(List<IEpisode> episodes, ITemporalDependencyState temporalState) {
        ArrayList filtered = Lists.newArrayList();
        for (IEpisode episode : episodes) {
            if (temporalState.getEpisodeState(episode.getId()).getState().equals((Object)EpisodeState.Empty)) continue;
            filtered.add(episode);
        }
        return filtered;
    }

    private static Set<String> getIdsForStrictPhase(Map<String, List<IEpisode>> possibleReleases, IBacklog backlog) {
        HashSet strictPhase = Sets.newHashSet();
        BiMap<String, IProcessingItem> items = RmIdentifiableUtils.createIdMap(backlog.getProcessingItems());
        for (Map.Entry<String, List<IEpisode>> releaseEntry : possibleReleases.entrySet()) {
            if (releaseEntry.getValue().size() != 1 || releaseEntry.getValue().get(0).isLaterRelease()) continue;
            String itemId = releaseEntry.getKey();
            strictPhase.add(itemId);
            IProcessingItem item = (IProcessingItem)items.get(itemId);
            Set<IProcessingItem> transitivePrerequisites = backlog.getDependencyDefinition().getTransitivePrerequisites(item);
            strictPhase.addAll(RmIdentifiableUtils.getIds(transitivePrerequisites));
        }
        return strictPhase;
    }
}

