/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.actset.IActivitySetSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.AbstractItemSchedulingProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IItemAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourceGroup;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.common.IMutableResourcePool;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.assignment.AssignmentRestriction;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.problem.IRoadmapProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivitySet;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IProcessingItem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IRoadmapProblemStatistics;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.ProcessingItemType;
import com.atlassian.rm.jpo.scheduling.util.LogUtil;
import com.google.common.base.Joiner;
import java.util.Set;

public class ActivitySetSchedulingProblem
extends AbstractItemSchedulingProblem
implements IActivitySetSchedulingProblem {
    private static final Log LOGGER = Log.with(ActivitySetSchedulingProblem.class);
    private final IActivitySet activitySet;
    private final int maxResourcesPerStage;
    private final int itemReleaseTime;

    ActivitySetSchedulingProblem(IActivitySet activitySet, int releaseTime, int upperTimeBound, Set<IMutableResourcePool> availableResourcePools, IRoadmapProblemStatistics projectStatistics, int maxResourcesPerStage, boolean stageTransitionEnforced, int itemReleaseTime, IEpisode episode, boolean schedulingEnforced, boolean planningHorizonReached) {
        super(activitySet.getId(), releaseTime, upperTimeBound, availableResourcePools, projectStatistics, stageTransitionEnforced, episode, schedulingEnforced, planningHorizonReached);
        this.activitySet = activitySet;
        this.maxResourcesPerStage = maxResourcesPerStage;
        this.itemReleaseTime = itemReleaseTime;
    }

    @Override
    public IActivitySet getActivitySet() {
        return this.activitySet;
    }

    @Override
    public int getMaxResourcesPerStage() {
        return this.maxResourcesPerStage;
    }

    @Override
    public int getCausalReleaseTime() {
        return this.itemReleaseTime;
    }

    @Override
    public ProcessingItemType getProcessingItemType() {
        return ProcessingItemType.ActivitySet;
    }

    @Override
    public IProcessingItem getProcessingItem() {
        return this.activitySet;
    }

    public String toString() {
        return "ActivitySetSchedulingProblem [activitySet=" + this.activitySet + ", lowerTimeBound=" + this.getLowerTimeBound() + ", upperTimeBound= " + this.getUpperTimeBound() + ", assignableResourceGroups=" + Joiner.on((String)",").join(this.getMutableResourcePools()) + ", projectStatistics=" + this.getProjectStatistics() + "]";
    }

    public static IActivitySetSchedulingProblem createInstance(IItemAssignmentProblem assignmentProblem, Set<IMutableResourceGroup> mutableResourceGroups, IRoadmapProblem problem) {
        LogUtil.debug(LOGGER, "create instance for assignment problem: %s", assignmentProblem);
        int problemLowerTimeBound = Math.max(assignmentProblem.getCausalReleaseTime(), assignmentProblem.getLowerTimeBound());
        IProcessingItem item = assignmentProblem.getProcessingItem();
        AssignmentRestriction assignmentRestriction = item.getAssignmentRestriction();
        Set<IMutableResourcePool> availableResourcePools = assignmentRestriction.filterMutableResourcePools(mutableResourceGroups);
        ActivitySetSchedulingProblem instance = new ActivitySetSchedulingProblem((IActivitySet)item, problemLowerTimeBound, assignmentProblem.getUpperTimeBound(), availableResourcePools, problem.getRoadmapStatistics(), problem.getProcessingDefinition().getMaxResourcesPerStage(), problem.getProcessingDefinition().isStageTransitionEnforced(), assignmentProblem.getCausalReleaseTime(), assignmentProblem.getProjectEpisode(), assignmentProblem.isSchedulingEnforced(), assignmentProblem.isUpperTimeBoundPlanningHorizon());
        LogUtil.debug(LOGGER, "created instance: %s", instance);
        return instance;
    }
}

