/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.IFixedSlotsAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.PeriodActivityMapping;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.PeriodAssignmentProblemTransformationResult;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.heuristics.period.DefaultPeriodAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.resources.IWorkResource;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IActivity;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IResourceType;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IStageTask;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.work.IUnstructuredItem;
import com.atlassian.rm.jpo.scheduling.util.RmSortableUtils;
import com.atlassian.rm.jpo.scheduling.util.collection.PositivePrimitivesMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class PeriodAssignmentProblemTransformer {
    PeriodAssignmentProblemTransformationResult transform(IWorkSlot workSlot, IFixedSlotsAssignmentProblem problem) {
        IWorkResource resource;
        int r;
        IResourceType type;
        int s;
        PeriodActivityMapping periodActivityMapping = PeriodActivityMapping.create(problem.getAssignmentProblemsForSlot(workSlot));
        List<IWorkResource> sortedResources = RmSortableUtils.sort(problem.getResourceAvailabilities(workSlot).keySet());
        List<IResourceType> sortedResourceTypes = problem.getSortedResourceTypes(workSlot);
        DefaultPeriodAssignmentProblem.Builder periodAssignmentProblem = DefaultPeriodAssignmentProblem.builder(periodActivityMapping.getPeriodActivities(), sortedResources.size(), sortedResourceTypes.size());
        periodAssignmentProblem.setWeights(1.0f);
        ArrayList assignmentIds = Lists.newArrayList();
        ArrayList activityToProcessingItems = Lists.newArrayList();
        int activityIndex = -1;
        for (IStageTask stageTask : periodActivityMapping.getStageTasks()) {
            ++activityIndex;
            assignmentIds.add(stageTask.getId());
            activityToProcessingItems.add(periodActivityMapping.getActivitySet(stageTask));
            for (s = 0; s < sortedResourceTypes.size(); ++s) {
                type = sortedResourceTypes.get(s);
                if (!stageTask.getResourceTypes().contains(type)) continue;
                periodAssignmentProblem.setDemand(activityIndex, s, stageTask.getPositiveTypeAmounts().get(type));
            }
            periodAssignmentProblem.setAssignmentLimit(activityIndex, 1);
            for (r = 0; r < sortedResources.size(); ++r) {
                resource = sortedResources.get(r);
                if (!stageTask.getAssignmentRestriction().getResources().contains(resource)) continue;
                periodAssignmentProblem.setActivityToResourceAssignable(activityIndex, r);
            }
        }
        for (IActivity activity : periodActivityMapping.getActivities()) {
            ++activityIndex;
            assignmentIds.add(periodActivityMapping.getActivitySet(activity).getId());
            activityToProcessingItems.add(periodActivityMapping.getActivitySet(activity));
            for (s = 0; s < sortedResourceTypes.size(); ++s) {
                type = sortedResourceTypes.get(s);
                if (!activity.getResourceTypes().contains(type)) continue;
                periodAssignmentProblem.setDemand(activityIndex, s, activity.getPositiveTypeAmounts().get(type));
            }
            periodAssignmentProblem.setAssignmentLimit(activityIndex, problem.getActivityResourceLimit());
            for (r = 0; r < sortedResources.size(); ++r) {
                resource = sortedResources.get(r);
                if (!periodActivityMapping.getActivitySet(activity).getAssignmentRestriction().getResources().contains(resource)) continue;
                periodAssignmentProblem.setActivityToResourceAssignable(activityIndex, r);
            }
        }
        for (IUnstructuredItem unstructuredItem : periodActivityMapping.getUnstructuredItems()) {
            ++activityIndex;
            assignmentIds.add(unstructuredItem.getId());
            activityToProcessingItems.add(unstructuredItem);
            for (s = 0; s < sortedResourceTypes.size(); ++s) {
                type = sortedResourceTypes.get(s);
                if (!unstructuredItem.getResourceTypes().contains(type)) continue;
                periodAssignmentProblem.setDemand(activityIndex, s, unstructuredItem.getWorkDemand().getPositiveTypeAmounts().get(type));
            }
            periodAssignmentProblem.setAssignmentLimit(activityIndex, sortedResources.size());
            for (r = 0; r < sortedResources.size(); ++r) {
                resource = sortedResources.get(r);
                if (!unstructuredItem.getAssignmentRestriction().getResources().contains(resource)) continue;
                periodAssignmentProblem.setActivityToResourceAssignable(activityIndex, r);
            }
        }
        this.setAvailabilities(problem.getResourceAvailabilities(workSlot), sortedResources, periodAssignmentProblem);
        this.setSkills(sortedResources, sortedResourceTypes, periodAssignmentProblem);
        return new PeriodAssignmentProblemTransformationResult(workSlot, activityToProcessingItems, sortedResources, problem.getResourceGroup(workSlot), sortedResourceTypes, periodAssignmentProblem.build(), problem.getStages(), assignmentIds);
    }

    private void setSkills(List<IWorkResource> sortedResources, List<IResourceType> sortedResourceTypes, DefaultPeriodAssignmentProblem.Builder periodAssignmentProblem) {
        for (int r = 0; r < sortedResources.size(); ++r) {
            for (int s = 0; s < sortedResourceTypes.size(); ++s) {
                periodAssignmentProblem.setSkill(r, s, sortedResources.get(r).getResourceTypes().contains(sortedResourceTypes.get(s)));
            }
        }
    }

    private void setAvailabilities(PositivePrimitivesMap<IWorkResource> resourceAvailabilities, List<IWorkResource> sortedResources, DefaultPeriodAssignmentProblem.Builder periodAssignmentProblem) {
        for (int r = 0; r < sortedResources.size(); ++r) {
            periodAssignmentProblem.setAvailability(r, resourceAvailabilities.get(sortedResources.get(r)));
        }
    }
}

