/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve;

import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.DefaultFixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotItemsSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotsAssignmentSolution;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.FixedSlotsAssignmentSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.common.IFixedSlotsAssignmentProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DistributeOverbookProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.DistributeOverbookProblemLpSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.MaximizationProblemLpSolver;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.MaximizeWorkProblem;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.solve.SolutionCreator;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.group.IWorkSlot;
import com.atlassian.rm.jpo.scheduling.util.RmUtils;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;

public class IterativeMultiSlotAssignmentSolver
implements FixedSlotsAssignmentSolver {
    public static final int MAX_RESOURCES_FOR_DISTRIBUTION = 40;
    private static final Log LOGGER = Log.with(IterativeMultiSlotAssignmentSolver.class);
    private final MaximizationProblemLpSolver maximizeWorkLpSolver = new MaximizationProblemLpSolver();
    private final DistributeOverbookProblemLpSolver distributionProblemLpSolver = new DistributeOverbookProblemLpSolver();

    @Override
    public FixedSlotsAssignmentSolution solve(IFixedSlotsAssignmentProblem slotsAssignmentProblem) {
        HashSet solutions = Sets.newHashSet();
        Set<IWorkSlot> slotsWithAssignments = slotsAssignmentProblem.getWorkSlotsWithAssignedItems();
        for (IWorkSlot workSlot : slotsWithAssignments) {
            LOGGER.debug("find schedule for slot: %s", workSlot);
            MaximizeWorkProblem maxWorkProblem = MaximizeWorkProblem.create(workSlot, slotsAssignmentProblem);
            Optional<float[]> nonOverbookedSolution = this.maximizeWorkLpSolver.solve(maxWorkProblem);
            Optional<FixedSlotItemsSolution> completeSolution = IterativeMultiSlotAssignmentSolver.getCompleteSolution(maxWorkProblem, nonOverbookedSolution);
            if (completeSolution.isPresent()) {
                solutions.add(completeSolution.get());
                LOGGER.debug("add complete solution found and added: %s", completeSolution.get());
                continue;
            }
            Optional<DistributeOverbookProblem> overbookProblem = IterativeMultiSlotAssignmentSolver.getOverbookProblem(maxWorkProblem, nonOverbookedSolution);
            if (overbookProblem.isPresent()) {
                LOGGER.debug("schedule with overbooked work", new Object[0]);
                float[] overbookSolution = this.distributionProblemLpSolver.solve((DistributeOverbookProblem)overbookProblem.get());
                solutions.add(SolutionCreator.create((DistributeOverbookProblem)overbookProblem.get(), overbookSolution));
                continue;
            }
            LOGGER.debug("slot problem too complex - items must be ignored", new Object[0]);
            solutions.add(SolutionCreator.createTooComplexViolationSolution(maxWorkProblem));
        }
        FixedSlotsAssignmentSolution solution = DefaultFixedSlotsAssignmentSolution.create(solutions);
        LOGGER.debug("found solution: %s", solution);
        return solution;
    }

    private static Optional<DistributeOverbookProblem> getOverbookProblem(MaximizeWorkProblem maxWorkProblem, Optional<float[]> nonOverbookedSolution) {
        if (IterativeMultiSlotAssignmentSolver.isProblemTooComplexForDistributionSolver(maxWorkProblem)) {
            return Optional.absent();
        }
        return Optional.of((Object)DistributeOverbookProblem.create(maxWorkProblem, IterativeMultiSlotAssignmentSolver.getNotOverbookedWork(nonOverbookedSolution)));
    }

    private static float getNotOverbookedWork(Optional<float[]> nonOverbookedSolution) {
        if (nonOverbookedSolution.isPresent()) {
            return RmUtils.sum((float[])nonOverbookedSolution.get());
        }
        return 0.0f;
    }

    private static Optional<FixedSlotItemsSolution> getCompleteSolution(MaximizeWorkProblem maxWorkProblem, Optional<float[]> nonOverbookedSolution) {
        if (nonOverbookedSolution.isPresent()) {
            return SolutionCreator.tryCreateCompleteSolution(maxWorkProblem, (float[])nonOverbookedSolution.get());
        }
        return Optional.absent();
    }

    private static boolean isProblemTooComplexForDistributionSolver(MaximizeWorkProblem maxWorkProblem) {
        return maxWorkProblem.getResources().size() > 40;
    }
}

