/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.rm.jpo.scheduling.roadmap.scheduling.algo.construct.fixed.trafo;

import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.EpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.solution.IEpisodeSchedule;
import com.atlassian.rm.jpo.scheduling.roadmap.scheduling.data.time.IEpisode;
import com.atlassian.rm.jpo.scheduling.util.IIdentifiable;
import com.atlassian.rm.jpo.scheduling.util.function.IIntegerInterval;
import com.google.common.base.Optional;
import com.google.common.collect.BiMap;
import java.util.LinkedHashMap;
import java.util.Map;

class MinEpisodeStartShiftSelector {
    MinEpisodeStartShiftSelector() {
    }

    Optional<IEpisodeSchedule> tryGetMinShiftSchedule(IIntegerInterval solutionInterval, LinkedHashMap<IEpisode, Optional<Integer>> possibleEpisodesToStart, BiMap<String, IEpisodeSchedule> episodeSchedules) {
        int minEarliestStartShift = Integer.MAX_VALUE;
        IIdentifiable minEarliestStartShiftEpisode = null;
        for (Map.Entry<IEpisode, Optional<Integer>> entry : possibleEpisodesToStart.entrySet()) {
            int diff;
            if (!entry.getValue().isPresent() || (diff = (Integer)entry.getValue().get() - solutionInterval.getStart()) <= 0 || diff >= minEarliestStartShift) continue;
            minEarliestStartShift = diff;
            minEarliestStartShiftEpisode = entry.getKey();
        }
        if (minEarliestStartShiftEpisode != null) {
            if (episodeSchedules.containsKey((Object)minEarliestStartShiftEpisode.getId())) {
                return Optional.of((Object)episodeSchedules.get((Object)minEarliestStartShiftEpisode.getId()));
            }
            return Optional.of((Object)EpisodeSchedule.createEmpty((IEpisode)minEarliestStartShiftEpisode, solutionInterval.getStart()));
        }
        return Optional.absent();
    }
}

